/*
 *  SAtomicStack.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 8/30/10.
 *  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SAtomicStack_h__ )
#define __SAtomicStack_h__

#include <CoreFoundation/CoreFoundation.h>

typedef struct OpaqueSAtomicStack *SAtomicStackRef;

SAtomicStackRef SAtomicStackCreate( void *(^nextElementBlock)(void*), void (^copyNextElementBlock)(void*, void*) );
void SAtomicStackDestroy( SAtomicStackRef self );

/* Non-atomic operations */
void SAtomicStackNonAtomicPush( SAtomicStackRef self, void *inItem );
void *SAtomicStackNonAtomicPop( SAtomicStackRef self );

/* Atomic operations */
void SAtomicStackPush( SAtomicStackRef self, void *inItem );
void *SAtomicStackPop( SAtomicStackRef self );
void *SAtomicStackPopAll( SAtomicStackRef self );
void *SAtomicStackPopAllReversed( SAtomicStackRef self );

Boolean SAtomicStackIsEmpty( SAtomicStackRef self );

#endif //__SAtomicStack_h__