//
//  AtomicStack.h
//  TapeDeck
//
//  Created by Christopher Liscio on 5/21/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol LinkedObject<NSObject>
- (id)next;
- (void)setNext:(id)next;
@end

@interface AtomicStack : NSObject {
    id<LinkedObject> mHead;
}

- (void)nonAtomicPush:(id<LinkedObject>)item;
- (id<LinkedObject>)nonAtomicPop;
- (BOOL)isEmpty;
- (void)push:(id<LinkedObject>)item;
- (id<LinkedObject>)pop;
- (id<LinkedObject>)popAll;
- (id<LinkedObject>)popAllReversed;

@end
