//
//  Waveform.h
//  Capo
//
//  Created by Christopher Liscio on 2/4/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface Waveform : NSObject

- (id)initWithFileURL:(NSURL *)inURL cacheFileURL:(NSURL *)inCacheURL;

- (void)preProcess;
- (BOOL)processAudioBlock;
- (void)finishProcessing;

/** The actual waveform data as an array of floats.
 */
@property(nonatomic, readonly, assign) float *waveformSamples;

/** Specifies the number of waveform samples contained in the waveformData array.
 */
@property(nonatomic, readonly, assign) uint64_t sampleCount;

/** Specifies how many audio frames are contained in a single waveform sample
 */
@property (nonatomic,readonly,assign) uint64_t framesPerSample;

/** The sample rate of the underlying audio file
 */
@property (nonatomic,readonly,assign) SInt64 sampleRate;

/** Returns whether the waveform has completed processing
 */
@property(nonatomic, readonly, assign, getter=isProcessingComplete) BOOL processingComplete;

- (NSRange)sampleRangeForFrameRange:(NSRange)inFrameRange;

@end

extern NSString *WaveformDidBeginScanningFileNotification;
extern NSString *WaveformDidFinishScanningFileNotification;
extern NSString *WaveformHasAvailableFramesNotification;