//
//  SStringedInstrumentTuning.h
//  Capo
//
//  Created by Christopher Liscio on 5/3/10.
//  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SMUGChordShape;

@interface SStringedInstrumentTuning : NSObject <NSCopying, NSCoding> {
    NSString *mName;
    NSString *mNoteString;    
    NSArray *mStringPitches;
    uint8_t mCapo;
    uint8_t mFretCount;
}

+ (instancetype)stringedInstrumentTuning;
- (instancetype)initWithPitches:(NSArray*)pitches fretCount:(uint8_t)fretCount capo:(uint8_t)capo name:(NSString*)name noteString:(NSString*)noteString;
- (NSArray *)pitchesForShape: (SMUGChordShape*)shape withOffset:(int8_t)semiToneOffset;

@property (nonatomic, readonly,copy) NSArray *stringPitches;
@property (nonatomic, readonly,copy) NSString *name;
@property (nonatomic, readonly,copy) NSString *noteString;
@property (nonatomic, readonly,assign) uint8_t stringCount;
@property (nonatomic, readonly,assign) uint8_t fretCount;
@property (nonatomic, readonly,assign) uint8_t capo;

@end
