//
//  SPitch.h
//  Capo
//
//  Created by Christopher Liscio on 11/26/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SNote;

@interface SPitch : NSObject <NSCoding, NSCopying> {
    uint8_t mMIDINote;
}

+ (SPitch*)pitchWithMIDINote:(uint8_t)midiNote;
+ (SPitch*)pitchWithNote:(SNote*)note octave:(uint8_t)octave;

- (id)initWithMIDINote:(uint8_t)midiNote;
- (id)initWithNote:(SNote*)note octave:(uint8_t)octave;

@property (nonatomic,readonly,assign) uint8_t midiNote;
@property (nonatomic,readonly,assign) uint8_t octave;
@property (nonatomic,readonly,copy) SNote *note;

- (int8_t)offsetFromPitch:(SPitch*)pitch;
- (SPitch*)pitchAtOffset:(int8_t)inOffset;

- (BOOL)isEqualToPitch:(SPitch*)otherPitch;
- (NSComparisonResult)compare: (SPitch *)other;

@end
