//
//  SNote.h
//  Capo
//
//  Created by Christopher Liscio on 9/9/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

@interface SNote : NSObject <NSCopying,NSCoding> {
    NSString *mString;
    NSString *mDisplayString;
    uint8_t mNoteValue;
}

+ (SNote*)noteWithString:(NSString*)inputString;
+ (SNote*)noteWithValue:(uint8_t)value;

- (id)initWithString:(NSString*)inputString;
- (id)initWithValue:(uint8_t)value;
- (id)initWithValue:(uint8_t)value flat:(BOOL)flat;

- (SNote*)noteWithOffset:(int8_t)offset;
- (int8_t)offsetToNote:(SNote *)otherNote;
- (int8_t)offsetFromNote:(SNote *)otherNote;

- (BOOL)isEqualToNote:(SNote *)other;

@property (nonatomic, readonly,copy) NSString *string;
@property (nonatomic, readonly,copy) NSString *displayString;
@property (nonatomic, readonly,assign) uint8_t noteValue;

@end

enum {
    S_NOTE_C = 0,
    S_NOTE_C_SHARP = 1,
    S_NOTE_D_FLAT = 1,
    S_NOTE_D = 2,
    S_NOTE_D_SHARP = 3,
    S_NOTE_E_FLAT = 3,
    S_NOTE_E = 4,
    S_NOTE_F = 5,
    S_NOTE_F_SHARP = 6,
    S_NOTE_G_FLAT = 6,
    S_NOTE_G = 7,
    S_NOTE_G_SHARP = 8,
    S_NOTE_A_FLAT = 8,
    S_NOTE_A = 9,
    S_NOTE_A_SHARP = 10,
    S_NOTE_B_FLAT = 10,
    S_NOTE_B = 11,
};