//
//  CapoVocalReductionEffectSettings.h
//  CapoKit
//
//  Created by Alan Westbrook on 3/21/14.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <CapoKit/SMUGDictionarySerialization.h>

@interface SMUGVocalReductionEffectSettings : NSObject <NSCopying, SMUGDictionarySerialization> {
@public
    double _lowFrequency;
    double _highFrequency;
}

@property (nonatomic, assign) double lowFrequency;
@property (nonatomic, assign) double highFrequency;
@property (nonatomic, readonly, assign) NSUInteger roundLowFrequency;
@property (nonatomic, readonly, assign) NSUInteger roundHighFrequency;
@property (nonatomic, strong) NSString *name;

+ (NSArray *)vocalPresets;

@end
