//
//  SMUGViterbi.h
//  CapoKit
//
//  Created by Christopher Liscio on 2/11/2014.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGRealVector.h>
#import <SMUGMath/SMUGRealMatrix.h>

/**
 Note: This file currently just contains a "toy implementation" of the Viterbi algorithm and a test function to ensure it works. I'm just placing it into the source so we have a reference to work from.
 */

enum {
    kHealthyState = 0,
    kFeverState,
    kStateCount,
};
typedef size_t state_t;

enum {
    kNormalObservation = 0,
    kColdObservation,
    kDizzyObservation,
    kObservationCount,
};
typedef size_t observation_t;

SMUGRealVector *SMUG_viterbi( observation_t *inObservations, size_t inObservationCount, state_t *inStates, size_t inStateCount,  SMUGRealVector *inStartProbabilities, SMUGRealMatrix *inTransitionProbabilities, SMUGRealMatrix *inEmissionProbabilities );