//
//  SMUGStandardPitchReference.h
//  CapoKit
//
//  Created by Christopher Liscio on 2/3/2014.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SMUGStandardPitchReference : NSObject

/** Returns object with default "standard pitch" (i.e. A440) frequency value of 440.0Hz
 */
+ (instancetype)standardPitchReference;

/** Returns object with custom "standard pitch" (i.e. A440) frequency value
 
 @param inStandardPitch Specifies the custom standard pitch value for fine-tuning.
 
 */
- (id)initWithStandardPitch:(float)inStandardPitch;

@property(nonatomic, readonly, assign) float standardPitch;

- (float)frequencyForMIDINote:(float)inNote;

@end
