//
//  SMUGRealVector_Chroma.h
//  Capo
//
//  Created by Christopher Liscio on 12/24/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <SMUGMath/SMUGMath.h>

@class SChord;

@interface SMUGRealVector (Chroma)

+ (SMUGRealVector*)majorChordChromaVector;
+ (SMUGRealVector*)minorChordChromaVector;

+(SMUGRealVector *)majorScaleChromaVector;

- (SMUGRealVector*)matchesToMajorMinorChromas;
-(SMUGRealVector *)matchesToMajorScaleChromas;

-(SMUGRealVector *)matchesToMajorScaleChordChromas;

- (SMUGRealVector*)chromaVectorWithBinsPerOctave:(uint32_t)bpo octavesToEvaluate:(uint32_t)octaveCount;

// Based on Adam Stark's method
- (NSDictionary*)chromaVectorWithSampleRate:(float)sampleRate;

- (SChord *)likelyChordMatchWithLowChroma:(SMUGRealVector *)chromaLowVec;

- (NSArray *)likelyChordMatchesWithLowChroma:(SMUGRealVector *)chromaLowVec;
@end

extern NSString *kSMUGChromaVectorKey;
extern NSString *kSMUGChromaLowVectorKey;
