//
//  SMUGRealVectorSmoothingBuffer.h
//  ChordDetect
//
//  Created by Christopher Liscio on 12/14/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGMath.h>

@interface SMUGRealVectorSmoothingBuffer : NSObject {
    NSUInteger mLength;
    NSUInteger mCapacity;    
@private    
    NSUInteger mIndex;    
    NSUInteger mVectorLength;
}

- (id)initWithCapacity:(NSUInteger)inCapacity vectorLength:(NSUInteger)inVectorLength;

// # of items in the list
@property (nonatomic, readonly,assign) NSUInteger length;

// Total capacity of the list
@property (nonatomic, readonly,assign) NSUInteger capacity;

// Average of the items
- (SMUGRealVector*)average;

- (void)addRealVector:(SMUGRealVector*)inVector;

@end
