//
// Created by Christopher Liscio on 3/18/14.
//
// Copyright (c) 2014 SuperMegaUltraGroovy, Inc.
//


#import <Foundation/Foundation.h>
#import <CapoKit/Chromagram.h>

@class CapoNoteEntryStorage;

@interface SMUGModelInformedChordDetector : NSObject

- (instancetype)initWithJSONModelAtURL:(NSURL *)inURL;

@property(nonatomic, readwrite, weak) CapoNoteEntryStorage *noteEntryStorage;
@property(nonatomic, readwrite, strong) Chromagram *chromagram;
@property(nonatomic, readonly, strong) NSArray *chordLikelihoods;
@property(nonatomic, readonly, strong) NSArray *chordEntries;

- (void)runModelBasedDetection;

- (NSArray *)chordResultsAtSample:(uint64_t)inSample;

@end