//
//  SMUGFastConstantQWorkingSet.h
//  CapoKit
//
//  Created by Christopher Liscio on 3/23/14.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Accelerate/Accelerate.h>
#import <SMUGMath/SMUGMath.h>

@interface SMUGFastConstantQWorkingSet : NSObject

- (instancetype)initWithFFTSize:(uint64_t)inFFTSize binsPerOctave:(uint64_t)inBinsPerOctave binCount:(uint64_t)inBinCount minMIDINote:(uint8_t)inMinMIDINote;

@property(nonatomic, readonly, assign) DSPSplitComplex workingSplit;
@property(nonatomic, readonly, strong) SMUGRealVector *workingVector;

@property(nonatomic, readonly, assign) vDSP_Length workingWindowLength;
@property(nonatomic, readonly, strong) SMUGRealVector *workingWindowVector;

@property(nonatomic, readonly, strong) SMUGRealVector *workingMatrixVector;

@property(nonatomic, readonly, strong) SMUGRealVector *chromaWindowVector;

@property(nonatomic, assign) FFTSetup fftSetup;

@end
