//
//  SMUGFastConstantQPlan.h
//  Capo
//
//  Created by Christopher Liscio on 2/1/2014.
//  Copyright (c) 2014 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGRealVector.h>
#import <SMUGMath/SMUGRealMatrix.h>

@class SMUGFastConstantQWorkingSet;

@interface SMUGFastConstantQPlan : NSObject

- (id)initWithSampleRate:(unsigned int)sampleRate minMIDINote:(uint8_t)inMinMIDINote minFrequency:(float)minFreq maxFrequency:(float)maxFreq binsPerOctave:(unsigned int)binsPerOctave;

@property(nonatomic, readonly, assign) uint64_t binCount;
@property(nonatomic, readonly, assign) uint64_t fftSize;

@property(nonatomic, readonly, strong) SMUGFastConstantQWorkingSet *workingSet;

- (SMUGRealVector *)constantQTransformOfInputVector:(SMUGRealVector *)x withWorkingSet:(SMUGFastConstantQWorkingSet *)inWorkingSet;
- (SMUGRealVector *)constantQTransformOfInputVector:(SMUGRealVector *)x;

@end
