//
//  SMUGConstantQPlan.h
//  Capo
//
//  Created by Christopher Liscio on 12/9/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenCL/OpenCL.h>

@class SMUGOpenCLContext;
@class SMUGOpenCLProgram;
@class SMUGOpenCLKernel;
@class SMUGRealVector;

@interface SMUGConstantQPlan : NSObject {
    unsigned int mSkipLength;
    SMUGOpenCLContext *mContext;
    SMUGOpenCLProgram *mProgram;
    SMUGOpenCLKernel *mKernel;
    SMUGRealVector *mQ2PiCosVector;
    SMUGRealVector *mQ2PiSinVector;
    SMUGRealVector *mInputVector;
    uint32_t mBinCount;
    
    cl_mem input_mem;
    cl_mem sinQ2Pi_mem;
    cl_mem cosQ2Pi_mem;
}

- (id)initWithSampleRate:(unsigned int)sampleRate
    inputVector:(SMUGRealVector*)inputVector
    skipLength:(unsigned int)skipLength
    minFrequency:(float)minFrequency
    maxFrequency:(float)maxFrequency
    binsPerOctave:(unsigned int)binsPerOctave
    usesGPU:(BOOL)usesGPU;
    
- (SMUGRealVector*)constantQTransformInRange:(NSRange)sampleRange;

    
@property (readonly,strong) SMUGOpenCLContext *context;
@property (readonly,strong) SMUGOpenCLProgram *program;
@property (readonly,strong) SMUGRealVector *Q2PiCosVector;
@property (readonly,strong) SMUGRealVector *Q2PiSinVector;
@property (readonly,assign) uint32_t binCount;

@end
