//
//  SMUGColor.h
//  SMUGLib
//
//  Created by Alan Westbrook on 11/13/13.
//  Copyright (c) 2013 SuperMegaUltraGroovy. All rights reserved.
//

#if TARGET_OS_IPHONE
#define BaseColor UIColor
#else
#define BaseColor NSColor
#endif

@interface SMUGColor : BaseColor
+ (instancetype)whiteColor;
+ (instancetype)blackColor;
+ (instancetype)clearColor;

+ (instancetype)colorWithWhite:(CGFloat)white alpha:(CGFloat)alpha;
+ (instancetype)colorWithSRGBHexString:(NSString *)inHexString alphaComponent:(CGFloat)inAlphaComponent;
+ (instancetype)colorWith8BitRed:(UInt8)red green:(UInt8)green blue:(UInt8)blue floatAlpha:(CGFloat)alpha;

- (SMUGColor *)colorWithAlphaComponent:(CGFloat)alpha;

@end
