//
//  SMUGChromagramCalculator.h
//  CapoKit
//
//  Created by Christopher Liscio on 2/3/2014.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGMath.h>

@class SMUGStandardPitchReference;
@class SMUGRealVector;
@class SMUGFastConstantQPlan;
@class SMUGFastConstantQWorkingSet;

@interface SMUGChromagramCalculator : NSObject

- (id)initWithSampleRate:(uint64_t)inSampleRate binsPerOctave:(uint64_t)inBinsPerOctave pitchReference:(SMUGStandardPitchReference *)inPitchReference minMIDINote:(uint8_t)inMinMIDINote maxMIDINote:(uint8_t)inMaxMIDINote;

- (SMUGRealVector *)chromaVectorWithInput:(SMUGRealVector *)input workingSet:(SMUGFastConstantQWorkingSet *)inWorkingSet;

@property(nonatomic, readonly, strong) SMUGFastConstantQPlan *plan;

@property(nonatomic, readonly, assign) uint32_t binsPerOctave;
@property(nonatomic, readonly, assign) uint32_t binCount;
@property(nonatomic, readonly, assign) uint8_t minMIDINote;
@property(nonatomic, readonly, assign) uint8_t maxMIDINote;

@end
