//
//  CapoChordGridLayer.h
//  Capo
//
//  Created by Alan Westbrook on 6/26/13.
//  Copyright (c) 2013 SuperMegaUltraGroovy. All rights reserved.
//

@import QuartzCore.CALayer;

@class SMUGChordShape;
@class SMUGFretIndicator;
@class SMUGBarreIndicator;
@class SMUGColor;
@class SMUGChordDrawingScheme;
@class SMUGChordDrawingStyle;

@interface SMUGChordGridLayer : CALayer

@property (nonatomic,strong) SMUGChordShape *shape;
@property (nonatomic, strong) SMUGChordDrawingStyle *drawingStyle;

+ (instancetype)layerWithScheme:(SMUGChordDrawingScheme *)scheme;

- (CGPoint)positionForIndicator: (SMUGFretIndicator *)indicator;
- (CGFloat)widthForBarre: (SMUGBarreIndicator*)barre;
- (CGFloat)yPositionForIndicatorAtFret:(uint8_t)fret;

@end
