//
// Created by Christopher Liscio on 7/15/13.
//
// Copyright (c) 2013 SuperMegaUltraGroovy, Inc.
//

@class SMUGChordDrawingScheme;
@class CapoChordEntry;
@class SMUGChordEntryLabelLayer;
@class SMUGChordShape;
@class SMUGChordShapeLayer;

@protocol CapoChordManager;

@interface SMUGChordEntryLayer : CALayer

+ (instancetype)layerWithChordEntry:(CapoChordEntry *)inChordEntry drawingScheme:(SMUGChordDrawingScheme *)scheme;

@property(nonatomic,weak) id<CapoChordManager> chordManager;
@property(nonatomic,readonly,strong) CapoChordEntry *chordEntry;
@property(nonatomic,assign) BOOL chordShapeVisible;
@property(nonatomic,assign) BOOL showChordBoxes;
@property(nonatomic,assign) BOOL selected;
@property(nonatomic,assign) BOOL ellipsized;
@property(nonatomic,readonly,strong) SMUGChordShape *shape;
@property(nonatomic,readonly,strong) SMUGChordShapeLayer *shapeLayer;
@property(nonatomic,readonly,strong) SMUGChordDrawingScheme *scheme;

// These are pass-throughs to the underlying label
- (void)setChordDescription:(NSAttributedString *)chordDescription;
- (NSAttributedString *)chordDescription;

- (void)animateChordShapeVisibility;
- (CGSize)chordShapeVisibleSize;
- (void)reloadShape;
- (void)setupShapeLayer;
- (void)updateShapeLayerVisibility;
- (void)updateBounds;

@end
