//
//  SMUGChordDrawingScheme.h
//  CapoKit
//
//  Created by Alan Westbrook on 1/7/14.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//


@class SMUGChordDrawingStyle;
@class SMUGColor;

@interface SMUGChordDrawingScheme : NSObject

- (SMUGChordDrawingStyle *)normalStyle;
- (SMUGChordDrawingStyle *)selectedStyle;

- (SMUGColor *)fretMarkerFontColor;
- (NSString *)fretMarkerFontFace;
- (CGFloat)fretBoxBottomMargin;
- (CGFloat)fretBoxTopMargin;
- (CGFloat)fretBoxLeftMargin;
- (CGFloat)fretBoxWidth;
- (CGFloat)fretBoxHeight;
- (CGFloat)fretIndicatorDiameter;
- (CGFloat)barreIndicatorDiameter;
- (CGFloat)fretMarkerDiameter;
- (CGFloat)fretMarkerStretchedDiameter;
- (CGFloat)fretMarkerFontSize;
- (CGFloat)fretMarkerSpacing;
- (CGPoint)fretMarkerTextAlignmentOffset;
- (CGFloat)mutedStringIndicatorHeight;
- (CGFloat)mutedStringIndicatorWidth;
- (CGFloat)mutedStringIndicatorLineThickness;
- (CGFloat)openStringIndicatorOffset;
- (CGFloat)openStringIndicatorLineThickness;

- (CGFloat)horizontalEdgeInset;
- (CGFloat)edgeLineThickness;
- (CGFloat)nutLineThickness;
- (CGFloat)fretLineThickness;
- (CGFloat)stringLineThickness;

- (CGFloat)midlineY;
- (CGFloat)midlineYCollapsed;
- (CGFloat)midlineThickness;

- (CGFloat)chordTimelineCircleRadius;
- (CGFloat)chordHorizontalLineMarginSpacing;
- (CGFloat)chordVerticalLineLabelMargin;
- (CGFloat)chordVerticalLineThickness;
- (CGFloat)chordLayerBottomMargin;

- (BOOL)labelGeometryFlipped;

@end
