//
//  SMUGBandedSparseMatrix.h
//  CapoKit
//
//  Created by Christopher Liscio on 2/6/2014.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGRealVector.h>

@interface SMUGBandedSparseMatrix : NSObject

- (instancetype)initWithRows:(NSUInteger)inRows columns:(NSUInteger)inColumns;

- (void)convertRowVector:(SMUGRealVector *)inVector toSparseRowAtIndex:(NSUInteger)inRow;

- (SMUGRealVector *)realVectorMultipliedByVector:(SMUGRealVector *)inVector;
- (SMUGRealVector *)realVectorMultipliedByVector:(SMUGRealVector *)inVector withWorkingVector:(SMUGRealVector *)inWorkingVector;

@end
