//
// Created by Christopher Liscio on 2/15/13.
//
// Copyright (c) 2013 SuperMegaUltraGroovy, Inc.
//


#import <Foundation/Foundation.h>

@class SMUGATBeatTrackerPreAnalysisResult;

@interface SMUGATBeatTracker : NSObject

- (id)initWithAudioFileAtURL:(NSURL *)inURL;

- (void)preprocessWithCompletionBlock:(void (^)(SMUGATBeatTracker *))completionBlock;
- (void)processWithCompletionBlock:(void (^)(SMUGATBeatTracker *))completionBlock;

- (BOOL)preprocessAudioBlock;
- (BOOL)finishPreprocessing;
- (BOOL)process;

@property(nonatomic, readonly, assign) int sampleRate;
@property(nonatomic, readonly, assign) float initialTempoEstimate;
@property(nonatomic, readonly, assign) float overallTempo;
@property(nonatomic, readonly, copy) NSArray *beatLocations;
@property(nonatomic, readonly, copy) NSArray *barLocations;
@property(nonatomic, readonly, assign) uint64_t firstDownbeatLocation;
@property(nonatomic, readonly, assign) uint64_t barBeatCount;

@property(nonatomic, assign) uint64_t overrideFirstDownbeatLocation;

// Supports the persisting of the pre-analysis results to disk
- (SMUGATBeatTrackerPreAnalysisResult *)preAnalysisResult;
- (void)setPreAnalysisResult:(SMUGATBeatTrackerPreAnalysisResult *)inPreAnalysisResult;

@end
