//
//  SChordIntervals.h
//  Capo
//
//  Created by Christopher Liscio on 12/28/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

/* Enumerate the intervals, giving them a name */
typedef enum {
    kPerfectUnisonInterval = 0,
    kMinor2ndInterval = 1,
    kMajor2ndInterval = 2,
    kMinor3rdInterval = 3,
    kMajor3rdInterval = 4,
    kPerfect4thInterval = 5,
    kDiminished5thInterval = 6,
    kPerfect5thInterval = 7,
    kAugmented5thInterval = 8,
    kDiminished7thInterval = 9, kMajor6thInterval = 9,/* or major 6th */
    kMinor7thInterval = 10,
    kMajor7thInterval = 11,
    
    kPerfectOctaveInterval = 12,
    
    kMinor9thInterval = kPerfectOctaveInterval + kMinor2ndInterval,
    kMajor9thInterval = kPerfectOctaveInterval + kMajor2ndInterval,
    kAugmented9thInterval = kPerfectOctaveInterval + kMinor3rdInterval,    
    kPerfect11thInterval = kPerfectOctaveInterval + kPerfect4thInterval,
    kAugmented11thInterval = kPerfectOctaveInterval + kDiminished5thInterval,    
    kMajor13thInterval = kPerfectOctaveInterval + kDiminished7thInterval,    
    
} SIntervalDistance;

#define kMaximumIntervalsInAChord 6
#define kMaximumRequiredIntervalsInAChord 2
#define kMaximumAlternateModifiers 6

typedef struct _SChordIntervals {
    uint32_t mID;
    SIntervalDistance mIntervals[kMaximumIntervalsInAChord];
    SIntervalDistance mRequiredIntervals[kMaximumRequiredIntervalsInAChord];
    char *mDisplayModifier;
    char *mAlternateModifiers[kMaximumAlternateModifiers];
} SChordIntervals;

enum {
    kPowerChordIntervals = 0,
    kMajorChordIntervals,
    kMinorChordIntervals,
    kAugmentedChordIntervals,
    kDiminishedChordIntervals,
    kAdd9ChordIntervals,
    kMajor4ChordIntervals,
    kMinorAdd9ChordIntervals,
    kMinor4ChordIntervals,
    kDiminished7ChordIntervals,
    kHalfDiminished7ChordIntervals,
    kMinor7ChordIntervals,
    kMinorMajor7ChordIntervals,
    kDominant7ChordIntervals,
    kMajor7ChordIntervals,
    kAugmented7ChordIntervals,
    kAugmentedMajor7ChordIntervals,
    kMinor9ChordIntervals,
    kDominant9ChordIntervals,
    kMajor9ChordIntervals,
    kAugmented9ChordIntervals,
    kMinor11ChordIntervals,
    kDominant11ChordIntervals,
    kMajor11ChordIntervals,
    kMinor13ChordIntervals,
    kDominant13ChordIntervals,
    kMajor13ChordIntervals,
    kDominant7Flat5ChordIntervals,
    kDominant7Flat9ChordIntervals,
    kAugmented7Flat9ChordIntervals,
    kMinor7Flat9ChordIntervals,
    kDominant7Sharp9ChordIntervals,
    kAugmented7Sharp9ChordIntervals,
    kMinor7Sharp9ChordIntervals,
    kDominant13Sharp11ChordIntervals,
    kSuspended2ChordIntervals,
    kSuspended4ChordIntervals,
    kMajor6ChordIntervals,
    kMinor6ChordIntervals,
    kChordIntervalsCount,
};

extern SChordIntervals gChords[];
uint32_t SChordIntervalNoteCount( SChordIntervals *chordIntervals );
SChordIntervals *SChordIntervalsWithID( uint32_t chordID );