//
//  SChord.h
//  Capo
//
//  Created by Christopher Liscio on 9/9/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SChordIntervals.h"

@class SNote;

@interface SChord : NSObject <NSCoding, NSCopying>

+ (SChord*)majorChordWithRootNote:(SNote*)rootNote;
+ (SChord*)minorChordWithRootNote:(SNote*)rootNote;
+ (SChord*)chordWithString:(NSString*)inputString;
- (id)initWithString:(NSString*)inputString;

- (id)initWithRootNote:(SNote*)rootNote intervals:(SChordIntervals*)intervals addedBase:(SNote*)addedBase;

- (SChord*)chordWithOffset:(int8_t)inOffset;
- (NSArray*)pitchesAtOctave:(int8_t)inOctave;
- (NSArray *)notes;

- (NSString*)stringValue;

- (BOOL)isEqualToChord:(SChord *)other;

@property(nonatomic, readonly,copy) SNote *root;
@property(nonatomic, readonly,copy) SNote *addedBase;
@property(nonatomic, readonly,assign,getter=isMinor) BOOL minor;
@property(nonatomic, readonly,assign,getter=isMajor) BOOL major;
@property(nonatomic, readonly) NSString *modifier;
@property(nonatomic, readonly) NSArray *requiredNotes;

@end