//
//  Chromagram.h
//  Capo
//
//  Created by Christopher Liscio on 12/19/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SChord, SNote;
@class Spectrogram;
@class SMUGStandardPitchReference;

@interface Chromagram : NSObject <NSCoding>

/** Instantiate a Chromagram object
 */
- (instancetype)initWithAudioFileAtURL:(NSURL *)inAudioFileURL;

/** The pitch reference object
 * Set this value before calling process in order to ensure that the Constant Q transform bins are properly aligned with the musical scale.
 */
@property(nonatomic, strong) SMUGStandardPitchReference *pitchReference;

/** The chromagram's underlying processing sample rate.
* A chromagram object runs its internal processing at an internally-determined sample rate. It is typically lower than that of the original recording.
*/
@property(nonatomic, readonly, assign) uint64_t processingSampleRate;

/** The sample rate of the original audio recording.
*/
@property(nonatomic, readonly, assign) uint64_t originalSampleRate;

@property(nonatomic, readonly, assign) uint64_t blockLength;
@property(nonatomic, readonly, assign) uint64_t skipLength;

/** Run the main processing loop
* The chromagram will use multi-threading internally in order to process its samples as quickly as possible. It is recommended that this is also called on a separate thread, given that it could block the main thread while loading its underlying audio data for processing.
*/
- (void)process;

/** Determine the sample location (in the original audio file's sample rate) for a given input sample.
*
*/
- (uint64_t)sampleForSegmentIndex:(NSUInteger)segmentIndex;

/** Given an audio sample (in the original audio file's sample rate), determine the segment index.
*
*/
- (NSUInteger)segmentIndexForSample:(uint64_t)sample;

- (NSArray *)copyOfSegments;

- (NSUInteger)segmentCount;
- (NSArray *)segments;
- (NSDictionary *)segmentAtIndex:(NSUInteger)index;

@end

extern NSString *ChromagramDidBeginProcessingNotification;
extern NSString *ChromagramDidFinishProcessingNotification;
