//
// Created by Christopher Liscio on 2/21/13.
//
// Copyright (c) 2013 SuperMegaUltraGroovy, Inc.
//


#import <Foundation/Foundation.h>
#import "CapoUserEntry.h"

// Represents the meter, or time signature. This _could_ change over the course of a song.
@interface CapoTimeSignatureEntry : CapoUserEntry

// A 2/4 Time Signature would have numerator=2 and denominator=4 to indicate two quarter-notes in a bar.
@property(nonatomic, assign) uint8_t numerator;

// Note: In MIDI, this value is specified as the exponent of the time signature denominator. 2 ^ (denominator). So 4/4 would have a denominator value of 2, because 2^2=4, and 4/8 would have a denominator value of 3 because 2^3=8. Et cetera...
@property(nonatomic, assign) uint8_t denominator;

@end