//
//  CapoSpectrumData.h
//  CapoEffects
//
//  Created by Christopher Liscio on 4/22/11.
//  Copyright 2011 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface CapoSpectrumData : NSObject {
    uint32_t mLength;
    uint32_t mSampleRate;
    uint32_t mSmoothedLength;
    int32_t mPosCount;
    int32_t mNegCount;
    double mSmoothingFraction;
    double mPanAmount;
    BOOL mDecibelConversion;
    NSMutableData *mLeft;
    NSMutableData *mRight;
    NSMutableData *mSmoothedFrequencyTable;
    NSMutableData *mSmoothedLeft;
    NSMutableData *mSmoothedRight;    
}

- (id)initWithLength:(uint32_t)inLength sampleRate:(uint32_t)inSampleRate;

@property (nonatomic, readonly,assign) uint32_t length;
@property (nonatomic, readonly,assign) uint32_t smoothedLength;
@property (nonatomic, readonly,assign) uint32_t sampleRate;
@property (nonatomic, assign) double panAmount;
@property (nonatomic, readonly) NSMutableData *leftData;
@property (nonatomic, readonly) NSMutableData *rightData;
@property (nonatomic, readonly) NSMutableData *smoothedLeftData;
@property (nonatomic, readonly) NSMutableData *smoothedRightData;

- (void)setLeftSpectrum:(float*)inLeftSpectrum withLength:(uint32_t)inLength;
- (void)setRightSpectrum:(float*)inRightSpectrum withLength:(uint32_t)inLength;

- (void)getLeftSpectrum:(float*)outLeftSpectrum withLength:(uint32_t)inLength;
- (void)getRightSpectrum:(float*)outRightSpectrum withLength:(uint32_t)inLength;
- (void)getMixedSpectrum:(float*)outMixedSpectrum withLength:(uint32_t)inLength;

- (void)getSmoothedLeftSpectrum:(float*)outLeftSpectrum withLength:(uint32_t)inLength;
- (void)getSmoothedRightSpectrum:(float*)outRightSpectrum withLength:(uint32_t)inLength;
- (void)getSmoothedMixedSpectrum:(float*)outMixedSpectrum withStride:(uint32_t)inStride length:(uint32_t)inLength;

- (void)getSmoothedSpectrumWithLength:(uint32_t)inLength block:(void (^)(const float *leftSpectrum, const float *rightSpectrum, uint32_t length))inBlock;

@end

@interface CapoSpectrumData (Drawing)
- (void)drawMixedSpectrumInContext:(CGContextRef)ctx withSize:(CGSize)inSize foregroundColor:(CGColorRef)inForegroundColor backgroundColor:(CGColorRef)inBackgroundColor;
- (void)drawSpectrumInContext:(CGContextRef)ctx withSize:(CGSize)inSize foregroundLeftColor:(CGColorRef)inForegroundLeftColor foregroundRightColor:(CGColorRef)inForegroundRightColor backgroundColor:(CGColorRef)inBackgroundColor panAmount:(double)inPanAmount;

#if TARGET_OS_IPHONE
- (UIImage*)mixedSpectrumImageWithSize:(CGSize)inSize foregroundColor:(CGColorRef)inForegroundColor backgroundColor:(CGColorRef)inBackgroundColor;
- (UIImage*)spectrumImageWithSize:(CGSize)inSize foregroundLeftColor:(CGColorRef)inForegroundLeftColor foregroundRightColor:(CGColorRef)inForegroundRightColor backgroundColor:(CGColorRef)inBackgroundColor panAmount:(double)inPanAmount;
#endif
@end