//
//  CapoNoteEntryPlaybackStorage.h
//  Capo
//
//  Created by Christopher Liscio on 6/22/12.
//  Copyright (c) 2012 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CapoKit/CapoNoteEntryStorage.h>

@class CapoMetronomeInstrument;

typedef struct {
    uint64_t location;
    uint64_t length;
    uint64_t eventId;
    uint8_t midiNote;
    uint8_t velocity;
    uint8_t channel;
} CapoPlaybackNoteEntry;

@interface CapoNoteEntryPlaybackStorage : NSObject
- (void)updatePlaybackStorage:(CapoNoteEntryStorage *)inStorage;

@property(nonatomic, strong) CapoMetronomeInstrument *metronomeInstrument;
@property(nonatomic, assign) BOOL accentsDownbeats;
@end

#if defined(__cplusplus)
extern "C" {
#endif
BOOL CapoNoteEntryPlaybackStorageGetNoteEntriesStartingInRange( CapoNoteEntryPlaybackStorage* storage, NSRange range, uint64_t *ioSize, CapoPlaybackNoteEntry *outEntries );
BOOL CapoNoteEntryPlaybackStorageGetBeatEntriesStartingInRange( CapoNoteEntryPlaybackStorage* storage, NSRange range, uint64_t *ioSize, CapoPlaybackNoteEntry *outEntries );
    
BOOL CapoNoteEntryPlaybackStorageGetNoteEntriesEndingInRange( CapoNoteEntryPlaybackStorage* storage, NSRange range, uint64_t *ioSize, CapoPlaybackNoteEntry *outEntries );
BOOL CapoNoteEntryPlaybackStorageGetBeatEntriesEndingInRange( CapoNoteEntryPlaybackStorage* storage, NSRange range, uint64_t *ioSize, CapoPlaybackNoteEntry *outEntries );
    
#if defined(__cplusplus)
}
#endif