//
//  CapoNoteEntry.h
//  Capo
//
//  Created by Christopher Liscio on 1/29/10.
//  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CapoUserEntry.h"

@class SPitch;
@class SStringedInstrumentTuning;

@interface CapoNoteEntry : CapoUserEntry <NSCoding>

@property (nonatomic,readwrite,copy) SPitch *pitch;
@property (nonatomic,readwrite,assign) uint64_t length;
@property (nonatomic,readwrite,assign) uint8_t fretSelection;
@property (nonatomic,readwrite,assign) uint8_t channel;

- (void)increaseFretSelectionWithTuning:(SStringedInstrumentTuning*)tuning;
- (void)decreaseFretSelectionWithTuning:(SStringedInstrumentTuning*)tuning;

@end
