//
//  CapoMusicInformationRetrievalController.h
//  CapoKit
//
//  Created by Christopher Liscio on 3/27/14.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class CapoNoteEntryStorage;

@interface CapoMusicInformationRetrievalController : NSObject

- (instancetype)initWithAudioFileURL:(NSURL *)inAudioFileURL uuid:(NSString *)inUUIDString noteEntryStorage:(CapoNoteEntryStorage *)inNoteEntryStorage;

- (void)beginProcessing;
- (void)cancelProcessing;

- (double)progress;
@end

/** Notification that informs the registered listeners of the overall MIR processing progress. */
extern NSString *CapoMusicInformationRetrievalProgressNotification;

/** Contains a NSString description of the progress update. */
extern NSString *CapoMusicInformationRetrievalProgressDescriptionKey;

/** Contains a NSNumber with the progress in the range [0,1] */
extern NSString *CapoMusicInformationRetrievalProgressValueKey;

extern NSString *CapoMusicInformationRetrievalDidBeginProcessingNotification;
extern NSString *CapoMusicInformationRetrievalDidFinishProcessingNotification;

extern NSString *CapoBeatDetectionDidBeginProcessingNotification;
extern NSString *CapoBeatDetectionDidFinishProcessingNotification;

extern NSString *CapoKeyDetectionDidBeginProcessingNotification;
extern NSString *CapoKeyDetectionDidFinishProcessingNotification;

extern NSString *CapoSpectrogramDidBeginProcessingNotification;
extern NSString *CapoSpectrogramDidFinishProcessingNotification;

extern NSString *CapoChromagramDidBeginProcessingNotification;
extern NSString *CapoChromagramDidFinishProcessingNotification;

extern NSString *CapoChordDetectionDidBeginProcessingNotification;
extern NSString *CapoChordDetectionDidFinishProcessingNotification;

extern NSString *CapoWaveformDidBeginProcessingNotification;
extern NSString *CapoWaveformDidFinishProcessingNotification;