//
// Created by Christopher Liscio on 7/10/13.
//
// Copyright (c) 2013 SuperMegaUltraGroovy, Inc.
//


#import <Foundation/Foundation.h>

typedef NS_ENUM( NSInteger, CapoMetronomeInstrumentIdentifier ) {
    CapoMetronomeTraditionalInstrument = 0,
    
    CapoMetronomeRimClickInstrument,
    CapoMetronomeCowbellInstrument,
    CapoMetronomeSquareClickInstrument,
    CapoMetronomeWoodBlockInstrument,

    CapoMetronomeInstrumentCount,
};

@interface CapoMetronomeInstrument : NSObject

+ (instancetype)instrumentWithIdentifier:(CapoMetronomeInstrumentIdentifier)inIdentifier;
+ (NSArray *)instruments;

@property (nonatomic, readonly, strong) NSString *name;
@property (nonatomic, readonly, assign) uint8_t midiNote;
@property (nonatomic, readonly, assign) uint8_t accentedMidiNote;

@property (nonatomic, readonly, assign) uint8_t velocity;
@property (nonatomic, readonly, assign) uint8_t accentedVelocity;

@end