//
//  AudioFilePlayer.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/2/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>
#import <CapoKit/CapoEffectsManager.h>

@class CapoOutputAudioUnit;
@class SMUGVocalReductionEffectSettings;
@class SMUGEqualizerSettings;
@class SMUGAudioStreamBasicDescription;
@class SMUGExtendedAudioFile;
@class SMUGAudioFileReader;
@class SMUGRealVector;

@protocol CapoExtendedAudioFilePlayerDelegate;
@protocol CapoSpectrumManager;

@interface CapoExtendedAudioFilePlayer : NSObject <CapoEffectsManager> {
    SMUGExtendedAudioFile *mAudioFile;
    CapoOutputAudioUnit *mOutputAudioUnit;
    BOOL mDone;
    CGFloat mCurrentTime;
    UInt64 mStartHostTime;
    
    SInt64 mCurrentFrame;

    SMUGAudioFileReader *mFileReader;
    
    BOOL mNoiseInsertionNotificationSent;
}

@property (nonatomic, readonly, strong) CapoOutputAudioUnit *outputAudioUnit;
@property (nonatomic, readwrite, weak) id<CapoExtendedAudioFilePlayerDelegate> delegate;
@property (nonatomic, readwrite, assign,getter=isLooping) BOOL looping;
@property (nonatomic, readonly, assign) SInt64 totalFrames;
@property (nonatomic, readwrite, assign) SInt64 currentFrame;
@property (nonatomic, readonly, assign) SInt64 sampleRate;
@property (nonatomic, readonly, assign) CGFloat maxTime;
@property (nonatomic, readonly, assign) UInt32 channelCount;

- (void)setLoopRange:(NSRange)loopRange;
- (NSRange)loopRange;

// Vocal reduction
@property (nonatomic, readwrite,assign) BOOL vocalReductionEnabled;
@property (nonatomic, readwrite,strong) SMUGVocalReductionEffectSettings *vocalReductionEffectSettings;

// Pan adjustment
@property (nonatomic, readwrite,assign) BOOL monoEnabled;
@property (nonatomic, readwrite,assign) double monoPanAmount;
@property (nonatomic, readwrite,assign) BOOL outOfPhase;

// EQ
@property (nonatomic, readwrite,assign) BOOL equalizerEnabled;
@property (nonatomic, readwrite,strong) SMUGEqualizerSettings *equalizerSettings;

@property (nonatomic, readwrite,assign) double noteEntryPlaybackLevel;

@property (nonatomic, readonly, getter=isRunning) BOOL running;
@property (nonatomic, readonly) SInt64 processingLatency;
@property (nonatomic, readonly) double millisecondsPerFrame;

@property (nonatomic, readwrite,assign) int64_t prerollSampleStart;
@property (nonatomic, readwrite,assign) BOOL preroll;

- (id)initWithAudioFile:(SMUGExtendedAudioFile*)audioFile forEffects:(BOOL)forEffects;
- (id)initWithFileURL:(NSURL*)url;
- (id)initForEffectsWithFileURL:(NSURL*)filename;
- (void)startFilePlaying;
- (void)stopFilePlaying;
- (BOOL)isFilePlaying;

- (void)setPlaybackSpeed:(double)speed;
- (double)playbackSpeed;

- (void)setPlaybackPitchInSemitones:(double)semis;
- (double)playbackPitchInSemitones;

- (void)setNoisyOutput:(BOOL)noisyOutput;
- (NSTimeInterval)remainingNoiseFreeTime;
- (void)setPlaybackLevel:(CGFloat)level;
- (void)setPlaybackVolume:(CGFloat)volume; // set in dB

- (void)writeSamplesInRange:(NSRange)range toFileURL:(NSURL*)fileURL;
- (void)cancelWriteToFile;

- (void) setCurrentTime: (double) milliseconds;

- (id<CapoSpectrumManager>)spectrumManager;

@end

@protocol CapoExtendedAudioFilePlayerDelegate <NSObject>
@optional

- (void)audioFilePlayerDidReadAudioFrames:(CapoExtendedAudioFilePlayer *)inExtendedAudioFilePlayer;
- (void)audioFilePlayerDidReachEndOfFile:(CapoExtendedAudioFilePlayer *)inExtendedAudioFilePlayer;
- (void)audioFilePlayerDidStartInsertingNoise:(CapoExtendedAudioFilePlayer *)inExtendedAudioFilePlayer;
- (void)audioFilePlayer:(CapoExtendedAudioFilePlayer*)afp updatedExportWithProgress:(NSNumber*)pct;

@end
