//
//  CapoChordManager.h
//  Capo
//
//  Created by Alan Westbrook on 5/8/13.
//  Copyright (c) 2013 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SChord;
@class CapoChordEntry;
@class SMUGChordShape;

@protocol CapoChordManager <NSObject>
@required
- (NSArray *)candidateChordResultsAtSample:(uint64_t)inSample;

- (SChord *)transposedChordForDisplay:(SChord *)inChord;
- (SChord *)transposedChordForPlayback:(SChord *)inChord;

- (SChord *)untransposedChord:(SChord *)inChord;

- (SMUGChordShape *)shapeForChordEntry:(CapoChordEntry *)entry;
- (void)setShape:(SMUGChordShape *)shape forChordEntry:(CapoChordEntry *)entry;

- (SMUGChordShape *)shapeForChord:(SChord *)chord;
- (NSArray *)shapesForChord:(SChord *)chord;

- (void)playChord:(SChord *)chord;
- (void)playShape:(SMUGChordShape*)shape;
- (double)chordPlaybackVolume;
- (void)setChordPlaybackVolume:(double)volume;

- (CapoChordEntry *)changeChordEntry:(CapoChordEntry *)entry toChord:(SChord *)chord;

@end

extern NSString *CapoChordManagerDetectorReadyNotification;
extern NSString *CapoChordManagerShapeChangedForEntryNotification;
extern NSString *CapoChordManagerEntriesUpdatedNotification;
extern NSString *CapoChordManagerEntryKey;
extern NSString *CapoChordManagerRemovedEntriesKey;
extern NSString *CapoChordManagerAddedEntriesKey;

