//
//  CapoBeatsSettingsManager.h
//  CapoKit
//
//  Created by Alan Westbrook on 3/26/14.
//  Copyright (c) 2014 SuperMegaUltraGroovy, Inc. All rights reserved.
//

@class CapoTimeSignature;

#import <CapoKit/CapoCountInMode.h>
#import <CapoKit/SMUGMetronomeMode.h>
#import <CapoKit/CapoMetronomeInstrument.h>

@protocol CapoBeatsSettingsManager <NSObject>

@required
@property(nonatomic, strong) CapoTimeSignature *timeSignature;
@property(nonatomic, assign) SMUGMetronomeMode metronomeMode;
@property(nonatomic, assign) BOOL metronomeAccentsDownbeat;
@property(nonatomic, assign) CapoMetronomeInstrumentIdentifier metronomeInstrumentIdentifier;
@property(nonatomic, assign) CapoCountInDuration countInDuration;

- (NSUInteger)valueForCountInDuration:(CapoCountInDuration)duration;
- (NSArray *)timeSignaturePresets;

@end
