/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50610
Source Host           : localhost:3306
Source Database       : jswms

Target Server Type    : MYSQL
Target Server Version : 50610
File Encoding         : 65001

Date: 2015-10-09 09:41:45
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for `tab_customer`
-- ----------------------------
DROP TABLE IF EXISTS `tab_customer`;
CREATE TABLE `tab_customer` (
  `customer_pk` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `customer_name` varchar(255) COLLATE gbk_bin DEFAULT NULL,
  `customer_number` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '户编号客',
  `pact_number` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '合同编号',
  `pact_start` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '同合开始日期',
  `pact_end` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '同合截至日期',
  `person_name` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '系人联',
  `person_phone` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '话电',
  `person_email` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '邮箱',
  `storage_address` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '仓库地点',
  `storage_area` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '面积',
  `customer_state` varchar(255) COLLATE gbk_bin DEFAULT '启用' COMMENT '当前使用的合同',
  PRIMARY KEY (`customer_pk`),
  KEY `index_tab_customer` (`customer_number`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=gbk COLLATE=gbk_bin;

-- ----------------------------
-- Records of tab_customer
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_databasebackup`
-- ----------------------------
DROP TABLE IF EXISTS `tab_databasebackup`;
CREATE TABLE `tab_databasebackup` (
  `data_pk` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filepath` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `backup_date` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`data_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_databasebackup
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_goods`
-- ----------------------------
DROP TABLE IF EXISTS `tab_goods`;
CREATE TABLE `tab_goods` (
  `goods_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_customer_number` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `goods_number` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `batch_number` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `goods_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `goods_unit` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `goods_spec` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `per_unit` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `goods_tray` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`goods_pk`),
  KEY `index_tab_goods` (`goods_number`)
) ENGINE=InnoDB AUTO_INCREMENT=5222 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_goods
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_group`
-- ----------------------------
DROP TABLE IF EXISTS `tab_group`;
CREATE TABLE `tab_group` (
  `group_pk` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `xiugai` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '【设置权限】',
  PRIMARY KEY (`group_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_group
-- ----------------------------
INSERT INTO `tab_group` VALUES ('9', '管理员', '【设置权限】');

-- ----------------------------
-- Table structure for `tab_group_privilege`
-- ----------------------------
DROP TABLE IF EXISTS `tab_group_privilege`;
CREATE TABLE `tab_group_privilege` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `privilege_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3184 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_group_privilege
-- ----------------------------
INSERT INTO `tab_group_privilege` VALUES ('1033', '2', '基本信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1034', '2', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1035', '2', '产品信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1036', '2', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1037', '2', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1038', '2', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1039', '2', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('1040', '2', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1041', '2', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('1042', '2', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('1043', '2', '上架操作');
INSERT INTO `tab_group_privilege` VALUES ('1044', '2', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('1045', '2', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1046', '2', '下架操作');
INSERT INTO `tab_group_privilege` VALUES ('1047', '2', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('1048', '2', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1049', '2', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('1050', '2', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('1051', '2', '库存统计');
INSERT INTO `tab_group_privilege` VALUES ('1052', '2', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('1053', '2', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('1054', '2', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('1055', '2', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('1056', '2', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('1057', '2', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('1058', '2', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('1059', '2', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('1060', '2', '费率设置');
INSERT INTO `tab_group_privilege` VALUES ('1061', '2', '费用统计');
INSERT INTO `tab_group_privilege` VALUES ('1570', '5', '基本信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1571', '5', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1572', '5', '产品信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1573', '5', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1574', '5', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1575', '5', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1576', '5', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('1577', '5', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1578', '5', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('1579', '5', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('1580', '5', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('1581', '5', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('1582', '5', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1583', '5', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('1584', '5', '出库流水');
INSERT INTO `tab_group_privilege` VALUES ('1585', '5', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('1586', '5', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('1587', '5', '库存统计');
INSERT INTO `tab_group_privilege` VALUES ('1588', '5', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('1589', '5', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('1590', '5', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('1591', '5', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('1592', '5', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('1593', '5', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('1594', '5', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('1595', '5', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('1596', '5', '费率设置');
INSERT INTO `tab_group_privilege` VALUES ('1597', '5', '费用统计');
INSERT INTO `tab_group_privilege` VALUES ('1598', '6', '基本信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1599', '6', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1600', '6', '产品信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1601', '6', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1602', '6', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1603', '6', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1604', '6', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('1605', '6', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1606', '6', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('1607', '6', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('1608', '6', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('1609', '6', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('1610', '6', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1611', '6', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('1612', '6', '出库流水');
INSERT INTO `tab_group_privilege` VALUES ('1613', '6', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('1614', '6', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('1615', '6', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('1616', '6', '库存统计');
INSERT INTO `tab_group_privilege` VALUES ('1617', '6', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('1618', '6', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('1619', '6', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('1620', '6', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('1621', '6', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('1622', '6', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('1623', '6', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('1624', '6', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('1625', '6', '费率设置');
INSERT INTO `tab_group_privilege` VALUES ('1626', '6', '费用统计');
INSERT INTO `tab_group_privilege` VALUES ('1627', '7', '基本信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1628', '7', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1629', '7', '产品信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1630', '7', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1631', '7', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1632', '7', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1633', '7', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('1634', '7', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1635', '7', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('1636', '7', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('1637', '7', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('1638', '7', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('1639', '7', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1640', '7', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('1641', '7', '出库流水');
INSERT INTO `tab_group_privilege` VALUES ('1642', '7', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('1643', '7', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('1644', '7', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('1645', '7', '库存统计');
INSERT INTO `tab_group_privilege` VALUES ('1646', '7', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('1647', '7', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('1648', '7', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('1649', '7', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('1650', '7', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('1651', '7', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('1652', '7', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('1653', '7', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('1654', '7', '费率设置');
INSERT INTO `tab_group_privilege` VALUES ('1655', '7', '费用统计');
INSERT INTO `tab_group_privilege` VALUES ('1656', '8', '基本信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1657', '8', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1658', '8', '产品信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1659', '8', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1660', '8', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1661', '8', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('1662', '8', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('1663', '8', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1664', '8', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('1665', '8', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('1666', '8', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('1667', '8', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('1668', '8', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('1669', '8', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('1670', '8', '出库流水');
INSERT INTO `tab_group_privilege` VALUES ('1671', '8', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('1672', '8', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('1673', '8', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('1674', '8', '库存统计');
INSERT INTO `tab_group_privilege` VALUES ('1675', '8', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('1676', '8', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('1677', '8', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('1678', '8', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('1679', '8', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('1680', '8', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('1681', '8', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('1682', '8', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('1683', '8', '费率设置');
INSERT INTO `tab_group_privilege` VALUES ('1684', '8', '费用统计');
INSERT INTO `tab_group_privilege` VALUES ('2940', '3', '基本信息');
INSERT INTO `tab_group_privilege` VALUES ('2941', '3', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2942', '3', '货物信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2943', '3', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2944', '3', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2945', '3', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2946', '3', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('2947', '3', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2948', '3', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('2949', '3', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('2950', '3', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('2951', '3', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('2952', '3', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2953', '3', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('2954', '3', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('2955', '3', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2956', '3', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('2957', '3', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('2958', '3', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('2959', '3', '库存查询');
INSERT INTO `tab_group_privilege` VALUES ('2960', '3', '流水查询');
INSERT INTO `tab_group_privilege` VALUES ('2961', '3', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('2962', '3', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('2963', '3', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('2964', '3', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('2965', '3', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('2966', '3', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('2967', '3', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('2968', '3', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('2969', '3', '标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('2970', '3', '非标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('2971', '3', '费率核算');
INSERT INTO `tab_group_privilege` VALUES ('2972', '3', '费率查看');
INSERT INTO `tab_group_privilege` VALUES ('2973', '10', '基本信息');
INSERT INTO `tab_group_privilege` VALUES ('2974', '10', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2975', '10', '货物信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2976', '10', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2977', '10', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2978', '10', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('2979', '10', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('2980', '10', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2981', '10', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('2982', '10', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('2983', '10', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('2984', '10', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('2985', '10', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2986', '10', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('2987', '10', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('2988', '10', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('2989', '10', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('2990', '10', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('2991', '10', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('2992', '10', '库存查询');
INSERT INTO `tab_group_privilege` VALUES ('2993', '10', '流水查询');
INSERT INTO `tab_group_privilege` VALUES ('2994', '10', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('2995', '10', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('2996', '10', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('2997', '10', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('2998', '10', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('2999', '10', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('3000', '10', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('3001', '10', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('3002', '10', '标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3003', '10', '非标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3004', '10', '费率核算');
INSERT INTO `tab_group_privilege` VALUES ('3005', '10', '费率查看');
INSERT INTO `tab_group_privilege` VALUES ('3062', '4', '基本信息');
INSERT INTO `tab_group_privilege` VALUES ('3063', '4', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3064', '4', '货物信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3065', '4', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3066', '4', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3067', '4', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3068', '4', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('3069', '4', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3070', '4', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('3071', '4', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('3072', '4', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('3073', '4', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('3074', '4', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3075', '4', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('3076', '4', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('3077', '4', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3078', '4', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('3079', '4', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('3080', '4', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('3081', '4', '库存查询');
INSERT INTO `tab_group_privilege` VALUES ('3082', '4', '流水查询');
INSERT INTO `tab_group_privilege` VALUES ('3083', '4', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('3084', '4', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('3085', '4', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('3086', '4', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('3087', '4', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('3088', '4', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('3089', '4', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('3090', '4', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('3091', '4', '标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3092', '4', '非标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3093', '4', '费率核算');
INSERT INTO `tab_group_privilege` VALUES ('3094', '4', '费率查看');
INSERT INTO `tab_group_privilege` VALUES ('3123', '9', '基本信息');
INSERT INTO `tab_group_privilege` VALUES ('3124', '9', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3125', '9', '货物信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3126', '9', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3127', '9', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3128', '9', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3129', '9', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('3130', '9', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3131', '9', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('3132', '9', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('3133', '9', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('3134', '9', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('3135', '9', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3136', '9', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('3137', '9', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('3138', '9', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3139', '9', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('3140', '9', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('3141', '9', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('3142', '9', '库存查询');
INSERT INTO `tab_group_privilege` VALUES ('3143', '9', '流水查询');
INSERT INTO `tab_group_privilege` VALUES ('3144', '9', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('3145', '9', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('3146', '9', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('3147', '9', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('3148', '9', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('3149', '9', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('3150', '9', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('3151', '11', '基本信息');
INSERT INTO `tab_group_privilege` VALUES ('3152', '11', '客户信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3153', '11', '货物信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3154', '11', '库位信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3155', '11', '员工信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3156', '11', '费率信息管理');
INSERT INTO `tab_group_privilege` VALUES ('3157', '11', '入库管理');
INSERT INTO `tab_group_privilege` VALUES ('3158', '11', '入库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3159', '11', '核实数量');
INSERT INTO `tab_group_privilege` VALUES ('3160', '11', '入库任务管理');
INSERT INTO `tab_group_privilege` VALUES ('3161', '11', '入库操作');
INSERT INTO `tab_group_privilege` VALUES ('3162', '11', '出库管理');
INSERT INTO `tab_group_privilege` VALUES ('3163', '11', '出库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3164', '11', '出库操作');
INSERT INTO `tab_group_privilege` VALUES ('3165', '11', '移库管理');
INSERT INTO `tab_group_privilege` VALUES ('3166', '11', '移库需求单管理');
INSERT INTO `tab_group_privilege` VALUES ('3167', '11', '移库操作');
INSERT INTO `tab_group_privilege` VALUES ('3168', '11', '移库记录');
INSERT INTO `tab_group_privilege` VALUES ('3169', '11', '库存管理');
INSERT INTO `tab_group_privilege` VALUES ('3170', '11', '库存查询');
INSERT INTO `tab_group_privilege` VALUES ('3171', '11', '流水查询');
INSERT INTO `tab_group_privilege` VALUES ('3172', '11', '流量统计');
INSERT INTO `tab_group_privilege` VALUES ('3173', '11', '容积率统计');
INSERT INTO `tab_group_privilege` VALUES ('3174', '11', '系统设置');
INSERT INTO `tab_group_privilege` VALUES ('3175', '11', '条码设置');
INSERT INTO `tab_group_privilege` VALUES ('3176', '11', '权限设置');
INSERT INTO `tab_group_privilege` VALUES ('3177', '11', '界面设置');
INSERT INTO `tab_group_privilege` VALUES ('3178', '11', '备份设置');
INSERT INTO `tab_group_privilege` VALUES ('3179', '11', '费率管理');
INSERT INTO `tab_group_privilege` VALUES ('3180', '11', '标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3181', '11', '非标准费率设置');
INSERT INTO `tab_group_privilege` VALUES ('3182', '11', '费率核算');
INSERT INTO `tab_group_privilege` VALUES ('3183', '11', '费率查看');

-- ----------------------------
-- Table structure for `tab_instock`
-- ----------------------------
DROP TABLE IF EXISTS `tab_instock`;
CREATE TABLE `tab_instock` (
  `instock_pk` int(11) NOT NULL AUTO_INCREMENT,
  `instock_number` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '入库单号',
  `fk_customer_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联客户表',
  `fk_staff_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联员工',
  `instock_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '收货日期',
  `instock_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `instock_bz` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`instock_pk`),
  KEY `index_tab_instock` (`instock_number`,`fk_customer_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=471 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_instock
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_instock_goods`
-- ----------------------------
DROP TABLE IF EXISTS `tab_instock_goods`;
CREATE TABLE `tab_instock_goods` (
  `instock_goods_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_instock_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联入库需求单',
  `fk_goods_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联出库需求单',
  `instock_ydcount` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '应到数量',
  `instock_sdcount` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '实到数量',
  `instock_taoxiang` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '掏箱规格',
  `instock_goods_xiehuo` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '叉车数量',
  `instock_goods_spec` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '每一个托盘的产品包装规格',
  `instock_goods_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '产品入库时间',
  `instock_goods_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '状态标志',
  `instock_parent` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '0为 没有被拆分   1为已经拆分',
  PRIMARY KEY (`instock_goods_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=10769 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_instock_goods
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_instock_print`
-- ----------------------------
DROP TABLE IF EXISTS `tab_instock_print`;
CREATE TABLE `tab_instock_print` (
  `instock_print_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_instock_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '主键',
  `instock_print_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '状态',
  `instock_print_count` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '数量',
  PRIMARY KEY (`instock_print_pk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_instock_print
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_landsurface`
-- ----------------------------
DROP TABLE IF EXISTS `tab_landsurface`;
CREATE TABLE `tab_landsurface` (
  `picture_pk` int(11) NOT NULL AUTO_INCREMENT,
  `pictureName` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `picturePath` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `myimage` longblob,
  PRIMARY KEY (`picture_pk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_landsurface
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_location`
-- ----------------------------
DROP TABLE IF EXISTS `tab_location`;
CREATE TABLE `tab_location` (
  `location_pk` int(11) DEFAULT NULL COMMENT '货位主键',
  `location_address` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '库区',
  `location_number` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '库位号',
  `location_area` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '面积',
  `location_class` varchar(255) COLLATE gbk_bin DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk COLLATE=gbk_bin;

-- ----------------------------
-- Records of tab_location
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_move`
-- ----------------------------
DROP TABLE IF EXISTS `tab_move`;
CREATE TABLE `tab_move` (
  `move_pk` int(11) NOT NULL AUTO_INCREMENT,
  `move_goodsnumber` varchar(255) DEFAULT NULL,
  `move_goodscount` varchar(255) DEFAULT NULL,
  `move_srclocation` varchar(255) DEFAULT NULL,
  `move_tarlocation` varchar(255) DEFAULT NULL,
  `move_staff` varchar(255) DEFAULT NULL,
  `move_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`move_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=1177 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tab_move
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_movestock`
-- ----------------------------
DROP TABLE IF EXISTS `tab_movestock`;
CREATE TABLE `tab_movestock` (
  `movestock_pk` int(11) NOT NULL AUTO_INCREMENT,
  `movestock_number` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '移库单号',
  `fk_staff_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '操作员',
  `movestock_date` varchar(255) CHARACTER SET latin1 COLLATE latin1_german1_ci DEFAULT NULL COMMENT '移库日期',
  `movestock_bz` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注',
  `movestock_state` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '状态',
  PRIMARY KEY (`movestock_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_movestock
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_movestock_goods`
-- ----------------------------
DROP TABLE IF EXISTS `tab_movestock_goods`;
CREATE TABLE `tab_movestock_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fk_movestock_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '移库单号',
  `fk_srclocation_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '原货位',
  `fk_goodsnub` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `fk_tarlocation_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '目标货位',
  `movestock_goods_count` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '移库产品数量',
  `movestock_goods_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1168 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_movestock_goods
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_outstockform`
-- ----------------------------
DROP TABLE IF EXISTS `tab_outstockform`;
CREATE TABLE `tab_outstockform` (
  `outstock_pk` int(11) NOT NULL AUTO_INCREMENT,
  `outstock_number` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库单号',
  `fk_customer_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联客户',
  `fk_staff_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '操作员',
  `outstock_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '日期',
  `outstock_count` int(11) DEFAULT NULL,
  `outstock_state` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '未处理',
  `outstock_remark` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`outstock_pk`),
  KEY `index_outstockfrom` (`outstock_number`,`fk_customer_pk`,`fk_staff_pk`,`outstock_state`)
) ENGINE=InnoDB AUTO_INCREMENT=648 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_outstockform
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_outstockgood_log`
-- ----------------------------
DROP TABLE IF EXISTS `tab_outstockgood_log`;
CREATE TABLE `tab_outstockgood_log` (
  `outgoods_pk` int(11) NOT NULL AUTO_INCREMENT COMMENT '出库日志主键',
  `outgoods_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `outgoods_count` int(11) DEFAULT NULL,
  `outgoods_date` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `outstock_number` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库单号',
  `fk_location_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库货位名称',
  `stock_state` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '状态（出库，入库，移库）',
  `beizhu` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`outgoods_pk`),
  KEY `index_stocklog` (`outgoods_name`),
  KEY `index_inoutstock` (`outgoods_name`)
) ENGINE=InnoDB AUTO_INCREMENT=17276 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_outstockgood_log
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_outstock_goods`
-- ----------------------------
DROP TABLE IF EXISTS `tab_outstock_goods`;
CREATE TABLE `tab_outstock_goods` (
  `outsock_goods_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_outstock_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关联出库单',
  `fk_goods_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '货物信息',
  `outstock_goods_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '状态标志',
  `outstock_count` int(11) DEFAULT NULL,
  `outstock_strategy` varchar(11) COLLATE utf8_bin DEFAULT '人工选择' COMMENT '出库货物库位的策略',
  `goods_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '货物名称',
  `goods_outcount` int(11) DEFAULT NULL COMMENT '已出库数量',
  `outstock_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库时间',
  `outstock_way` varchar(255) COLLATE utf8_bin DEFAULT '无' COMMENT '卸货方式',
  `tuopan_count` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`outsock_goods_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=2278 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_outstock_goods
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_outstrategy`
-- ----------------------------
DROP TABLE IF EXISTS `tab_outstrategy`;
CREATE TABLE `tab_outstrategy` (
  `outstrategy_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_outstock_number` varchar(255) DEFAULT NULL,
  `fk_goods_number` varchar(255) DEFAULT NULL,
  `fk_instock_date` varchar(255) DEFAULT NULL,
  `fk_storage_pk` varchar(255) DEFAULT NULL,
  `goods_count` varchar(255) DEFAULT NULL,
  `outstrategy_name` varchar(255) DEFAULT NULL,
  `outstrategy_state` varchar(255) DEFAULT NULL,
  `stock_pk` int(11) DEFAULT NULL COMMENT '库存表主键',
  `loaction_surplus` int(11) DEFAULT NULL,
  PRIMARY KEY (`outstrategy_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=16507 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tab_outstrategy
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_privilege`
-- ----------------------------
DROP TABLE IF EXISTS `tab_privilege`;
CREATE TABLE `tab_privilege` (
  `privilege_pk` int(11) NOT NULL AUTO_INCREMENT,
  `privilege_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `privilege_parents` int(11) DEFAULT NULL,
  PRIMARY KEY (`privilege_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_privilege
-- ----------------------------
INSERT INTO `tab_privilege` VALUES ('1', '基本信息', null);
INSERT INTO `tab_privilege` VALUES ('2', '入库管理', null);
INSERT INTO `tab_privilege` VALUES ('3', '出库管理', null);
INSERT INTO `tab_privilege` VALUES ('4', '移库管理', null);
INSERT INTO `tab_privilege` VALUES ('5', '库存管理', null);
INSERT INTO `tab_privilege` VALUES ('6', '系统设置', null);
INSERT INTO `tab_privilege` VALUES ('7', '客户信息管理', '1');
INSERT INTO `tab_privilege` VALUES ('8', '货物信息管理', '1');
INSERT INTO `tab_privilege` VALUES ('9', '库位信息管理', '1');
INSERT INTO `tab_privilege` VALUES ('10', '员工信息管理', '1');
INSERT INTO `tab_privilege` VALUES ('11', '费率信息管理', '1');
INSERT INTO `tab_privilege` VALUES ('12', '入库需求单管理', '2');
INSERT INTO `tab_privilege` VALUES ('13', '核实数量', '2');
INSERT INTO `tab_privilege` VALUES ('15', '标准费率设置', '26');
INSERT INTO `tab_privilege` VALUES ('16', '入库任务管理', '2');
INSERT INTO `tab_privilege` VALUES ('18', '出库需求单管理', '3');
INSERT INTO `tab_privilege` VALUES ('20', '移库需求单管理', '4');
INSERT INTO `tab_privilege` VALUES ('21', '库存查询', '5');
INSERT INTO `tab_privilege` VALUES ('22', '条码设置', '6');
INSERT INTO `tab_privilege` VALUES ('23', '权限设置', '6');
INSERT INTO `tab_privilege` VALUES ('24', '界面设置', '6');
INSERT INTO `tab_privilege` VALUES ('25', '备份设置', '6');
INSERT INTO `tab_privilege` VALUES ('26', '费率管理', null);
INSERT INTO `tab_privilege` VALUES ('27', '入库操作', '2');
INSERT INTO `tab_privilege` VALUES ('28', '非标准费率设置', '26');
INSERT INTO `tab_privilege` VALUES ('29', '流水查询', '5');
INSERT INTO `tab_privilege` VALUES ('30', '流量统计', '5');
INSERT INTO `tab_privilege` VALUES ('31', '出库操作', '3');
INSERT INTO `tab_privilege` VALUES ('32', '容积率统计', '5');
INSERT INTO `tab_privilege` VALUES ('33', '费率核算', '26');
INSERT INTO `tab_privilege` VALUES ('34', '移库操作', '4');
INSERT INTO `tab_privilege` VALUES ('35', '移库记录', '4');
INSERT INTO `tab_privilege` VALUES ('36', '费率查看', '26');

-- ----------------------------
-- Table structure for `tab_raterecord`
-- ----------------------------
DROP TABLE IF EXISTS `tab_raterecord`;
CREATE TABLE `tab_raterecord` (
  `id_pk` int(10) NOT NULL AUTO_INCREMENT COMMENT '费率核算的主键',
  `customer_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '客户名称',
  `my_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '时间',
  `cangchufee` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '仓储费',
  `instock_chache` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '叉车费',
  `instock_renli` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '人力费',
  `instock_chacherenli` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '叉车加人力费',
  `taoxiang20` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '20尺套箱费',
  `taoxiang40` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '40尺套箱费',
  `outstockrenli` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库人力费',
  `outstockchache` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库叉车费',
  `outstockchacherenli` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库叉车加人力费',
  `feibiaozhun` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '非标准费率',
  `hejifee` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '合计费',
  `cangchudanwei` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '仓储单位',
  `instockdanwei` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '入库单位',
  `oustockdanwei` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '出库单位',
  `cangchuliuliangfee` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_raterecord
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_ratesset`
-- ----------------------------
DROP TABLE IF EXISTS `tab_ratesset`;
CREATE TABLE `tab_ratesset` (
  `ratesset_pk` int(11) NOT NULL AUTO_INCREMENT COMMENT '费用设置主键',
  `customer_pk` varchar(255) COLLATE utf8_bin DEFAULT '0' COMMENT '客户关联',
  `danwei` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `cangchu_danjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_danjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_chachedanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_renlidanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_renlichachedanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_two` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instock_four` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `outstock_chachedanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `outstock_renlidanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `outstock_renlichachedanjia` varchar(255) COLLATE utf8_bin DEFAULT '0',
  `instockdanwei` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `outstockdanwei` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ratesset_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_ratesset
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_staff`
-- ----------------------------
DROP TABLE IF EXISTS `tab_staff`;
CREATE TABLE `tab_staff` (
  `staff_pk` int(11) NOT NULL AUTO_INCREMENT,
  `staff_number` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '员工工号',
  `staff_name` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '员工姓名',
  `staff_password` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '密码',
  `fk_group_pk` varchar(255) COLLATE gbk_bin DEFAULT NULL COMMENT '用户组',
  PRIMARY KEY (`staff_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=gbk COLLATE=gbk_bin;

-- ----------------------------
-- Records of tab_staff
-- ----------------------------
INSERT INTO `tab_staff` VALUES ('81', 'admin', 'admin', 'admin', '管理员');

-- ----------------------------
-- Table structure for `tab_stock`
-- ----------------------------
DROP TABLE IF EXISTS `tab_stock`;
CREATE TABLE `tab_stock` (
  `stock_pk` int(11) NOT NULL AUTO_INCREMENT,
  `fk_goods_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '货物',
  `fk_location_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '货位',
  `stock_date` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '入库日期',
  `fk_staff_pk` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '操作员',
  `stock_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '库存标志',
  `loaction_count` int(11) DEFAULT NULL,
  `loaction_surplus` int(11) DEFAULT NULL COMMENT '剩余量（拆包）',
  PRIMARY KEY (`stock_pk`),
  KEY `index_tab_stock` (`fk_goods_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=8321 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_stock
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_storage`
-- ----------------------------
DROP TABLE IF EXISTS `tab_storage`;
CREATE TABLE `tab_storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `storage_area` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `storage_id` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `storage_usablearea` double(255,0) DEFAULT NULL,
  `storage_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9698 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_storage
-- ----------------------------

-- ----------------------------
-- Table structure for `tab_unrate`
-- ----------------------------
DROP TABLE IF EXISTS `tab_unrate`;
CREATE TABLE `tab_unrate` (
  `unrate_pk` int(11) NOT NULL AUTO_INCREMENT,
  `customerName` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `cratedate` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `myamount` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `myimage` longblob,
  PRIMARY KEY (`unrate_pk`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of tab_unrate
-- ----------------------------
