﻿(function(){
	function loadValue( iNode ){
		var isCheckbox = this instanceof CKEDITOR.ui.dialog.checkbox;
		if ( iNode.hasAttribute( this.id ) ){
			var value = iNode.getAttribute( this.id );
			if ( isCheckbox )
				this.setValue( checkboxValues[ this.id ][ 'true' ] == value.toLowerCase() );
			else
				this.setValue( value );
		}
	}
	
	function commitValue( iNode ){
		var isRemove = this.getValue() === '',
			isCheckbox = this instanceof CKEDITOR.ui.dialog.checkbox,
			value = this.getValue();
		if ( isRemove ){
			iNode.removeAttribute( this.att || this.id );
		}else if ( isCheckbox ) {
			iNode.setAttribute( this.id, checkboxValues[ this.id ][ value ] );
		}else{
			iNode.setAttribute( this.att || this.id, value );
		}
	}
	
	CKEDITOR.dialog.add('videoplayer', function(editor){ 
		var tip1 = '<div style="border-bottom:1px solid #ddd; margin:0px 0px 10px; padding:8px 0px; font-size:14px;font-weight:bold;">说明</div>';
		tip1 += '<p style="color:#000;margin-bottom:10px; line-height:22px;">1. 支持mp4、flv、swf、mp3、avi、wmv等视频格式<br/>';
		tip1 += '2. 推荐使用<b style="color:red;font-weight:bold;">H.264编码的MP4格式视频</b>，此格式能在电脑、平板、手机观看。';
		tip1 += '<a href="http://jingyan.baidu.com/article/c1465413b5ebc40bfdfc4c7a.html" target="_blank" style="color:red;">如何转化为H.264编码的mp4格式？</a><br/>';
		tip1 += '3. 推荐将视频上传到第三方视频平台（如：优酷、土豆、搜狐视频等），然后再引用其<b style="color:red;font-weight:bold;">通用代码中的地址</b><br/>';
		tip1 += '4. 超过<b style="color:red;font-weight:bold;">5M</b>的视频文件请使用FTP软件上传，推荐使用FlashFxp上传<br/>';
		tip1 += '5. 在编辑器里，无法直接显示视频播放，需要保存后到前台页面查看效果。</p>';
		return {
			title: '插入视频', 
			resizable: CKEDITOR.DIALOG_RESIZE_NONE,  
			minWidth: 600,  
			minHeight: 380, 
			contents: [
				{  
					id: 'Upload',  
					hidden: true, 
					label: '上传视频',   
					filebrowser: 'uploadButton',				
					elements: [
						{
							type: 'text',
							id: 'src',
							label: '<div style="border-bottom:1px solid #ddd; margin:0px 0px 10px; padding:8px 0px; font-size:14px;font-weight:bold;">视频地址</div>',
							setup : loadValue,
							commit : commitValue
						},
						{
							type: 'hbox',
							widths: ['60%', '20%', '20%'],
							children: [
							   {
									type: 'file',
									id: 'upload',
									size: 38
								}, 
							   {
									type: 'fileButton',
									id: 'uploadButton',
									filebrowser: 'Upload:src',
									label: '上传到服务器上',
									'for': ['Upload', 'upload']
								},
								{
									type : 'button',
									id : 'browse',
									filebrowser :{
										action : 'Browse',
										target: 'Upload:src',
										url: editor.config.filebrowserImageBrowseLinkUrl
									},
									hidden : true,
									label : editor.lang.common.browseServer
								}
							]
						},
						{
							type:'html',
							html:'<div style="border-bottom:1px solid #ddd; margin:0px 0px 10px; padding:8px 0px; font-size:14px;font-weight:bold;">参数设置</div>'
						},
						{
							type: 'hbox',
							widths: ['30%', '30%','30%'],
							children: [
								{
									type: 'text',
									width: '40px',
									id: 'width',
									'default':'100%',
									label: '宽度（推荐设为100%，自适应宽度）',
									setup : loadValue,
									commit : commitValue
								},
								{
									type: 'text',
									width: '40px',
									id: 'height',
									'default':'320',
									label: '高度',
									setup : loadValue,
									commit : commitValue
								},
								{
									type: 'radio',
									id: 'autostart',
									items : [ [ '开启', '1' ], [ '关闭', '0' ] ] ,
									'default':'0',
									label: '<p style="margin-bottom:10px;">是否自动播放视频</p>',
									setup : loadValue,
									commit : commitValue
								}
							]
						},
						{
							type: 'html',
							html: tip1,
							id: 'help'
						}
					]  
				}
			], 
			onShow : function(){
					this.fakeImage = this.iPlayerNode = null;
					var fakeImage = this.getSelectedElement();
					if ( fakeImage && fakeImage.data( 'cke-real-element-type' ) && fakeImage.data( 'cke-real-element-type' ) == 'videoplayer' ){
						this.fakeImage = fakeImage;
						var iPlayerNode = editor.restoreRealElement( fakeImage );
						this.iPlayerNode = iPlayerNode;
						this.setupContent( iPlayerNode );
					}
			},
			onOk: function(){
					var iPlayerNode;
					if ( !this.fakeImage ){
						iPlayerNode = new CKEDITOR.dom.element( 'videoplayer' );
					}else{
						iPlayerNode = this.iPlayerNode;
					}
	
					var extraStyles = {}, extraAttributes = {};
					this.commitContent( iPlayerNode, extraStyles, extraAttributes );
	
					// Refresh the fake image.
					var newFakeImage = editor.createFakeElement( iPlayerNode, 'cke_videoplayer', 'videoplayer', true );
					newFakeImage.setAttributes( extraAttributes );
					newFakeImage.setStyles( extraStyles );
					if ( this.fakeImage ){
						newFakeImage.replace( this.fakeImage );
						editor.getSelection().selectElement( newFakeImage );
					}else{
						editor.insertElement( newFakeImage );
					}
				/*
				var src = this.getValueOf('Upload', 'url');  
				if(src!=""){
					var width = this.getValueOf('Upload', 'width');  
					var height = this.getValueOf('Upload', 'height'); 
					var autostart = this.getValueOf('Upload', 'autostart')=='1'?"true":"false";
					var vhtml = '<videoplayer style="width:350px;height:300px;background:#000;" src="'+src+'" width="'+width+'"  height="'+height+'"  autostart="'+autostart+'" />';
					editor.insertHtml(vhtml);
				}
				*/
	
			},  
			onLoad: function(){             
			}  
		};  
	});
})();