﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Transactions;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysReport.Model;
using SysReport.DAL;

public partial class System_XReport_XReport_Box : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public string action = "";
    XReport xr;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            Init_Page();
            Init_Filters();
        }
    }
    void Init_Page()
    {
        int id = Convert.ToInt32(Request["id"]);
        string module = Request.QueryString["module_code"];
        XReportDAL dal = new XReportDAL();
        xr = new XReport();
        module_code.Text = module;
        int report_id = dal.GetIdByCode(module);
        xr = dal.Get(report_id);
        xr_id.Value = xr.xr_id.ToString();
        module_name.Text = xr.module_name;
        html.Text = xr.html;
        temp_sql.Text = xr.temp_sql;
        report_sql.Text = xr.report_sql;
        column_names.Text = xr.column_names;
        keywords.Text = xr.keywords;
        date1.Text = xr.date1;
        date2.Text = xr.date2;
        textbox1.Text = xr.textbox1;
        textbox2.Text = xr.textbox2;
        order_field.Text = xr.order_field;
    }
    void Init_Filters()
    {
        XReportFilterDAL xf_dal = new XReportFilterDAL();
        cbl_filters.DataSource = xf_dal.GetListAll();
        cbl_filters.DataTextField = "xf_name";
        cbl_filters.DataValueField = "xf_code";
        cbl_filters.DataBind();
        if (xr.filters != null)
        {
            string[] arr_filters = xr.filters.Split(',');
            for (int i = 0; i < cbl_filters.Items.Count; i++)
            {
                for (int j = 0; j < arr_filters.Length; j++)
                {
                    if (cbl_filters.Items[i].Value.Equals(arr_filters[j]))
                    {
                        cbl_filters.Items[i].Selected = true;
                    }
                }
            }
        }
    }
    protected void btn_delete_Click(object sender, EventArgs e)
    {
        try
        {
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                ModuleDAL m_dal = new ModuleDAL();
                m_dal.Delete(module_code.Text);
                new XReportDAL().Delete(Convert.ToInt32(xr_id.Value));
                xview.Add("msg", "delete_success");
                //提交事务
                scope.Complete();
            }

        }
        catch (Exception err)
        {
            xview.Add("msg", err.Message);
        }
    }
    protected void btn_save_Click(object sender, EventArgs e)
    {
        if (module_code.Text.Trim().Equals(""))
        {
            xview.Add("msg","请输入模块编码");
            return;
        }
        if (module_name.Text.Trim().Equals(""))
        {
            xview.Add("msg", "请输入模块名称");
            return;
        }
        if (order_field.Text.Trim().Equals(""))
        {
            xview.Add("msg", "请输入排序字段");
            return;
        }
        XReportDAL dal = new XReportDAL();
        XReport xr = new XReport();
        xr.module_code = module_code.Text.Trim();
        xr.module_name = module_name.Text.Trim();
        xr.html = html.Text;
        xr.report_sql = report_sql.Text;
        xr.temp_sql = temp_sql.Text;
        xr.column_names = column_names.Text;
        xr.date1 = date1.Text.Trim();
        xr.date2 = date2.Text.Trim();
        xr.textbox1 = textbox1.Text.Trim();
        xr.textbox2 = textbox2.Text.Trim();
        xr.keywords = keywords.Text.Trim();
        xr.order_field = order_field.Text.Trim();

        string str = "";
        for (int i = 0; i < cbl_filters.Items.Count; i++)
        {
            if (cbl_filters.Items[i].Selected)
            {
                str += cbl_filters.Items[i].Value + ",";
            }
        }
        if (str.Length > 1)
        {
            str = str.Substring(0, str.Length - 1);
        }
        xr.filters = str;
        try
        {
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                action = "Edit";
                if (xr_id.Value.Trim().Equals("") || xr_id.Value.Trim().Equals("0"))
                {
                    action = "Add";
                    ModuleDAL m_dal = new ModuleDAL();
                    if (m_dal.CheckExist(module_code.Text))
                    {
                        xview.Add("msg","该模块编码已存在，请尝试使用其它编码！");
                        return;
                    }
                    dal.Add(xr);
                    AuthDAL auth_dal = new AuthDAL();
                    Auth auth = new Auth();
                    auth.auth_code = xr.module_code;
                    auth.auth_name = xr.module_name;
                    auth_dal.Add(auth);
                    Module m = new Module();
                    m.auth_code = xr.module_code;
                    m.module_code = xr.module_code;
                    m.module_name = xr.module_name;
                    m.node_img = "Report.png";
                    m.category = Request["module_code"];
                    m.url = "../../System/XReport/ViewReport.aspx?module_code=" + module_code.Text;
                    m.flow_url = "";
                    m_dal.Add(m);
                    //提交事务
                    scope.Complete();
                }
                else
                {
                    xr.xr_id = Convert.ToInt32(xr_id.Value);
                    dal.Update(xr);
                    //提交事务
                    scope.Complete();
                }

            }
        }
        catch (Exception err)
        {
            string info = err.Message;
            info = info.Replace("\r\n", "");
            xview.Add("msg", info);
            return;
        }
        xview.Add("msg", "save_success");
    }
}