﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
using SysReport;
using SysReport.Model;
using SysReport.DAL;

public partial class System_XReport_ViewReport : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    public ConfigReader cfg = new ConfigReader();
    AWGridFun aw = new AWGridFun();
    string module_code;
    XReportDAL dal;
    XReport xr;
    LoginInfo li;
    protected void Page_Load(object sender, EventArgs e)
    {
        li = new LoginInfo();
        dal = new XReportDAL();
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            xview.Add("begin_date", new LoginInfo().GetSearchBeginDate());
            xview.Add("end_date", new LoginInfo().login_date);

            int id = Convert.ToInt32(Request["id"]);
            module_code = Request.QueryString["module_code"];
            int report_id = dal.GetIdByCode(module_code);
            xr = dal.Get(report_id);

            //模块权限编号,同时作为模块号
            string auth_code = "Stock_ViewReport_" + module_code;
            xview.Add("auth_code", auth_code);
            //加载页面时建议不要指定网址，搜索时动态指定即可
            string url = "";
            xview.Add("grid_frame",aw.CreateGridFrame(url));
            InitSearchBox();
            InitFilters();
        }
    }
    void InitSearchBox()
    {
        xview["show_date1"] = " style='display:none'";
        xview["show_date2"] = " style='display:none'";
        xview["html"] = xr.html;
        if (!xr.date1.Equals(""))
        {
            try
            {
                string[] arr_date1 = xr.date1.Split('|');
                date1.Text = li.GetSearchBeginDate();
                date1_title.Text = arr_date1[0];
                xview["show_date1"] = "";
            }
            catch
            {
                msg.Text = "日期控件1配置不正确";
                return;
            }
        }
        if (!xr.date2.Equals(""))
        {
            try
            {
                string[] arr_date2 = xr.date2.Split('|');
                date2.Text = li.login_date;
                date2_title.Text = arr_date2[1];
                xview["show_date2"] = "";
            }
            catch
            {
                msg.Text = "日期控件2配置不正确";
                return;
            }
        }
        xview["show_textbox1"] = " style='display:none'";
        xview["show_textbox2"] = " style='display:none'";
        if (!xr.textbox1.Equals(""))
        {
            try
            {
                string[] arr_textbox1 = xr.textbox1.Split('|');
                textbox1_title.Text = arr_textbox1[0];
                xview["show_textbox1"] = "";
            }
            catch
            {
                msg.Text = "文本控件1配置不正确";
                return;
            }
        }
        if (!xr.textbox2.Equals(""))
        {
            try
            {
                string[] arr_textbox2 = xr.textbox2.Split('|');
                textbox2_title.Text = arr_textbox2[0];
                xview["show_textbox2"] = "";
            }
            catch
            {
                msg.Text = "文本控件2配置不正确";
                return;
            }
        }
    }
    void InitFilters()
    {
        XReportView view = new XReportView();
        Hashtable ht = view.GetFastSearch(xr);
        xview.Add("filters", ht["filters"]);
        xview.Add("search_pars", ht["search_pars"]);
        xview.Add("get_pars", ht["get_pars"]);
        xview.Add("fast_searchs", ht["fast_searchs"]);

        if (ht["filters"] == null || ht["filters"].Equals(""))
        {
            xview.Add("search_on_load", "1");
        }
    }
}