﻿<%@ WebService Language="C#" Class="DefaultPage_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
 [System.Web.Script.Services.ScriptService]
public class DefaultPage_Service  : System.Web.Services.WebService {

    [WebMethod(EnableSession = true)]
    public string GetQuickInfo(string range)
    {
        string sql = @"select SUM(quantity) as stock_quantity,sum(new_nat_unit_price*quantity) as stock_cost 
                       from Stock_OnHand oh
                       left join Base_Inventory i on oh.i_id=i.i_id";
        SqlUtil su = new SqlUtil();
        DataTable dt_st = su.GetDataTable(sql,null);
        string stock_quantity = dt_st.Rows[0]["stock_quantity"].ToString();
        string stock_cost = dt_st.Rows[0]["stock_cost"].ToString();

        sql = @"
                select 
                isnull((
	                select sum(nat_tax_total_price) as ying_shou
	                from ARAP_APDetail where rp_flag='AR'
                ),0)-
                isnull((
	                select sum(nat_amount) as shou_kuan
	                from ARAP_SFKuan
	                where rp_flag='AR' and isnull(verify_user,'')<>''
                ),0) as customer_balance,
                isnull((
	                select sum(nat_tax_total_price) as ying_fu
	                from ARAP_APDetail where rp_flag='AP'
                ),0)-
                isnull((
	                select sum(nat_amount) as fu_kuan
	                from ARAP_SFKuan
	                where rp_flag='AP' and isnull(verify_user,'')<>''
                ),0) as vendor_balance";
        DataTable dt_bl = su.GetDataTable(sql, null);
        string customer_balance = dt_bl.Rows[0]["customer_balance"].ToString();
        string vendor_balance = dt_bl.Rows[0]["vendor_balance"].ToString();
        LoginInfo li = new LoginInfo();
        DateTime t = DateTime.Parse(li.login_date);
        string year = t.Year.ToString();
        string month = t.Month.ToString();
        sql = @"select isnull(
        (
            select SUM(sos.nat_tax_total_price)
            from Sale_SalesOrders sos
            left join Sale_SalesOrder so on sos.so_id=so.so_id
            where year(so.new_date)=@year and month(so.new_date)=@month
            and isnull(so.verify_user,'')<>''
        ),0) as sales_order_amount,
        isnull(
        (
            select SUM(dos.nat_tax_total_price)
            from Sale_DeliveryOrders dos
            left join Sale_DeliveryOrder do on dos.do_id=do.do_id
            where year(do.new_date)=@year and month(do.new_date)=@month
            and isnull(do.verify_user,'')<>''
        ),0) as delivery_order_amount,
        isnull(
        (
            select SUM(pos.nat_tax_total_price)
            from Purchase_PurchaseOrders pos
            left join Purchase_PurchaseOrder po on pos.po_id=po.po_id
            where year(po.new_date)=@year and month(po.new_date)=@month
            and isnull(po.verify_user,'')<>''
        ),0) as purchase_order_amount,
        isnull(
        (
            select SUM(ios.tax_total_price)
            from Stock_InOuts ios
            left join Stock_InOut io on ios.io_id=io.io_id
            where io.order_type=3 and year(io.new_date)=@year and month(io.new_date)=@month
            and isnull(io.verify_user,'')<>''
        ),0) as purchase_in_amount";
        sql = sql.Replace("@year", year).Replace("@month", month);
        DataTable dt_oa = su.GetDataTable(sql, null);
        string sales_order_amount = dt_oa.Rows[0]["sales_order_amount"].ToString();
        string delivery_order_amount = dt_oa.Rows[0]["delivery_order_amount"].ToString();
        string purchase_order_amount = dt_oa.Rows[0]["purchase_order_amount"].ToString();
        string purchase_in_amount = dt_oa.Rows[0]["purchase_in_amount"].ToString();

        string res = stock_quantity + "|" + stock_cost
                    + "|" + customer_balance + "|" + vendor_balance
                    + "|" + sales_order_amount + "|" + delivery_order_amount
                    + "|" + purchase_order_amount + "|" + purchase_in_amount;
        return res;
    }
    
}