﻿<%@ WebService Language="C#" Class="Role_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Role_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除角色
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        RoleDAL dal = new RoleDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "角色已被用户使用,不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 新增角色
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Add(string role_name,string status)
    {
        role_name = role_name.Trim();
        if (role_name.Equals(""))
        {
            return "角色名不可为空！";
        }
        RoleDAL dal = new RoleDAL();
        Role m = new Role();
        m.role_name = role_name;
        m.status = status;
        if(dal.CheckExist(role_name))
        {
            return "角色【" + role_name + "】已存在！";
        }
        try
        {
            dal.Add(m);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
    /// <summary>
    /// 修改角色
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Update(int id,string role_name, string status)
    {
        RoleDAL dal = new RoleDAL();
        Role m = dal.Get(id);
        m.role_name = role_name;
        m.status = status;

        try
        {
            dal.Update(m);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
    /// <summary>
    /// 得到角色
    /// </summary>
    /// <param name="id">角色id</param>
    /// <returns>角色实体</returns>
    [WebMethod(EnableSession = true)]
    public Role GetRole(int id)
    {
        RoleDAL dal = new RoleDAL();
        Role m = dal.Get(id);
        string s = id.ToString();
        return m;
    }
}