﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class System_ModuleScript_ModuleScript_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "System_ModuleScript";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by ms_code";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "ms_code,ms_name,ms_type,remark";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }

        ht.Add("sql_end", sql_end);
        ModuleScriptDAL dal = new ModuleScriptDAL();
        //查询后返回DataTable
        DataTable dt = dal.GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_ModuleScript";
        //Session[sql_print_detail_session_id] = dal.sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = dal.GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }

}
