﻿<%@ WebService Language="C#" Class="ModuleFormat_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ModuleFormat_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 修改/// 
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Update(int id, string field_name, string title, int width
        , int sort, int show, int sum_field, string color, string auth_view, string auth_edit, int can_edit, string default_value)
    {
        ModuleFormatDAL dal = new ModuleFormatDAL();
        ModuleFormat m = dal.GetModuleFormat(id);
        m.field_name = field_name;
        m.title = title;
        m.width = width;
        m.sort = sort;
        m.show = show;
        m.sum_field = sum_field;
        m.color = color;
        m.auth_view = auth_view.Trim();
        m.auth_edit = auth_edit.Trim();
        m.can_edit = can_edit;
        m.default_value = default_value;
        try
        {
            dal.UpdateModuleFormat(m);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
    /// <summary>
    /// 保存排序
    /// </summary>
    /// <param name="ids">id号</param>
    /// <param name="sorts">显示顺序</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string SaveChange(string ids, string sorts)
    {
        ModuleFormatDAL dal = new ModuleFormatDAL();
        string [] arr_ids = ids.Split(',');
        string[] arr_sorts = sorts.Split(',');
        for(int i=0; i<arr_ids.Length; i++)
        {
            int id = Convert.ToInt32(arr_ids[i]);
            int sort = Convert.ToInt32(arr_sorts[i]);
            ModuleFormat m = dal.GetModuleFormat(Convert.ToInt32(id));
            m.sort = sort;
            
            try
            {
                dal.UpdateModuleFormat(m);
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 保存排序
    /// </summary>
    /// <param name="ids">id号</param>
    /// <param name="sorts">显示顺序</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string SetVisible(string ids)
    {
        ModuleFormatDAL dal = new ModuleFormatDAL();
        string [] arr_ids = ids.Split(',');
        for(int i=0; i<arr_ids.Length; i++)
        {
            int id = Convert.ToInt32(arr_ids[i]);
            ModuleFormat m = dal.GetModuleFormat(Convert.ToInt32(id));
            m.show = 1;
            try
            {
                dal.UpdateModuleFormat(m);
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    
}