﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ModuleFormat_List.aspx.cs" Inherits="ModuleFormat_ModuleFormat_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var module = '<%=xview["module"]%>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var url = "ModuleFormat_List_Grid.aspx?module=" + module;
            fg.src = url;
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid");//得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要查看的列!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一个列!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'ModuleFormat_Edit.aspx?action=Update&id=' + id,
                modal: true,
                title: '更多设置'
            });
        }
        //上下移动行
        function Move_Row(type){
          var fg = document.getElementById("frame_grid");//得到grid控件所在iframe
          var cw = fg.contentWindow;
          var id = cw.aw_GetSelectRows(cw._id); //返回一维数组
          if (id.length == 0) {
              AlertNO('请选择要调整顺序的列!');
              return;
          }
          if (id.length > 1) {
              AlertNO('一次只可以调整一个列!');
              return;
          }

          cw.swap_row(type);
        }
        //保存
        function save() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var sort = cw.aw_GetSelectRows(cw._sort); //排序列
            var data = cw.aw_myData;
            
            var ids = "";
            var sorts = "";
            for (var i = 0; i < data.length; i++) {
                ids += data[i][cw._id] + ",";
                sorts += data[i][cw._sort] + ",";
            }
            ids = ids.substring(0, ids.length - 1);
            sorts = sorts.substring(0, sorts.length - 1);
            
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'ModuleFormat_Service.asmx/SaveChange',
                data: "{ids:'" + ids + "',sorts:'" + sorts + "'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    var r = result.d;
                    if (r == "success") {
                        parent.AlertOK('保存成功!');
                        try {
                            parent.search_grid();
                            try {
                                CloseDivWin(); //关闭窗口
                            } catch (ex1) { }
                        } catch (ex2) {
                            parent.window.location = parent.window.location;
                        }
                    } else {
                        parent.AlertNO(r);
                    }
                }
            });

        }
        //设为可见
        function set_visible() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要设置的记录!');
                return;
            }
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: "ModuleFormat_Service.asmx/SetVisible",
                data: "{ids:'" + id + "'}",
                dataType: 'json',
                success: function (result) {
                    var r = result.d;
                    if (r == "success") {
                        AlertOK('已设为可见!');
                        fg.src = fg.src;
                    } else {
                        AlertNO(r);
                    }
                    HideLoadingMask(); //关闭遮罩
                }
            });
        }
       
    </script>
</head>
<body onload="search_grid()">
    <form id="main_form" runat="server">
    <div style="width:480px;height:380px;overflow:hidden;">
        <!--工具栏-->
        <div style="height:25px;margin-top:4px" class="list_menu_bar">
            
            <input type="button" class="SiteButton" value="上移" onclick="Move_Row('up')" style="margin-left:10px"/>
            <input type="button" class="SiteButton" value="下移" onclick="Move_Row('down')"/>
            <input type="button" class="SiteButton" value="保存排序" onclick="save()" title="在列表直接改表排序时需要点【应用设置】按钮，编辑单个项目则不需要"/>
            <input type="button" class="SiteButton" value="设为可见" onclick="set_visible()" title="可按shift或ctrl键进行批量选择"/>
            <input type="button" class="SiteButton" value="更多设置" onclick="modify()" />
        </div>
        <!--Grid控件所在的iframe-->
        <%=xview["grid_frame"]%>
    </div>
    </form>
</body>
</html>
