﻿<%@ WebService Language="C#" Class="Member_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Member_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除用户
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string uids)
    {
        MemberDAL dal = new MemberDAL();
        foreach (string uid in uids.Split(','))
        {
            try
            {
                dal.RemoveAdmin(Convert.ToInt32(uid));
                dal.Delete(Convert.ToInt32(uid));
            }
            catch (Exception e)
            {
                string msg = "用户已被使用或授权，不允许删除！详细错误：" + e.Message;
                return msg;
            }
        }
        return "success";
    }
    /// <summary>
    /// 新增用户
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Add(string username, string nickname, string password, string status, string role_ids, int is_admin)
    {
        username = username.Trim();
        password = password.Trim();
        if (username.Equals(""))
        {
            return "【用户名】不可为空！";
        }
        if (nickname.Equals(""))
        {
            return "【昵称】不可为空！";
        }
        if (password.Equals(""))
        {
            return "【密码】不可为空！";
        }
        if (status == "")
        {
            status = "0";
        }
        MemberDAL dal = new MemberDAL();
        Member m = new Member();
        m.username = username;
        if (!password.Equals(""))
        {
            m.password = XTools.Encrypt(password);
        }
        m.nickname = nickname;
        m.status = status;

        try
        {
            dal.Add(m);
            int new_uid = dal.GetMaxID();
            if (new_uid != 0)
            {
                //为用户分配角色
                dal.AddMemberRole(new_uid, role_ids);
                if(is_admin == 1)
                {
                    dal.AddAdmin(new_uid);
                }
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
    /// <summary>
    /// 修改用户
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Update(int uid, string username, string nickname, string password, string status,string is_admin, string role_ids)
    {
        username = username.Trim();
        password = password.Trim();
        if (username.Equals(""))
        {
            return "【用户名】不可为空！";
        }
        if (nickname.Equals(""))
        {
            return "【昵称】不可为空！";
        }
        if (status == "")
        {
            status = "0";
        }
        MemberDAL dal = new MemberDAL();
        Member m = dal.Get(uid);
        m.username = username;
        if (!password.Equals(""))
        {
            m.password = XTools.Encrypt(password);
        }
        m.nickname = nickname;
        m.status = status;

        try
        {
            bool b_admin = new AuthDAL().CheckUserIsAdmin(uid);
            //由非管理员变成管理员
            if (is_admin.Equals("1") && !b_admin)
            {
                dal.AddAdmin(uid);
            }
            //由管理员变成非管理员
            if (is_admin.Equals("0") && b_admin)
            {
                dal.RemoveAdmin(uid);
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }

        try
        {
            dal.Update(m);
            //为用户分配角色
            dal.AddMemberRole(uid, role_ids);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
    /// <summary>
    /// 得到用户
    /// </summary>
    /// <param name="uid">用户id</param>
    /// <returns>用户实体</returns>
    [WebMethod(EnableSession = true)]
    public Member Get(int uid)
    {
        MemberDAL dal = new MemberDAL();
        Member m = dal.Get(uid);
        string s = uid.ToString();
        return m;
    }
}