﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Member_List.aspx.cs" Inherits="Member_Member_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var username = $("#username").val();
            var status = $("#status").val();
            var url = "Member_List_Grid.aspx?username=" + username + "&status=" + status;
            fg.src = url;
        }
        //新增
        function add() {
            
	        asyncbox.open({
	            id: 'win_add',
	            url: '../Member/Member_Edit.aspx?action=Add',
                modal:true,
                title:'新增'
	        });
        }
        //授权
        function modify() {
            update();
        }
        //修改
        function update() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var uid = cw.aw_GetSelectRows(cw._uid); //返回一维数组
            if (uid.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (uid.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }

            asyncbox.open({
                id: 'win_modify',
                url: 'Member_Edit.aspx?action=Update&uid=' + uid,
                modal: true,
                title: '修改'
            });
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var uid = cw.aw_GetSelectRows(cw._uid);//返回一维数组
            if (uid.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "Member_Service.asmx/Delete",
                        data: "{uids:'" + uid + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        //授权
        function GiveAuthority() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var uid = cw.aw_GetSelectRows(cw._uid); //返回一维数组
            if (uid.length == 0) {
                AlertNO('请选择要授权的用户!');
                return;
            }
            if (uid.length > 1) {
                AlertNO('一次只可以操作一个用户!');
                return;
            }
            asyncbox.open({
                id: 'win_give_auth',
                url: '../GiveAuthority/GiveAuthority.aspx?type=Member&id=' + uid,
                modal: true,
                title: '授权'
            });   
        }
        //部门授限
        function GiveAuthority_Department() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var uid = cw.aw_GetSelectRows(cw._uid); //返回一维数组
            if (uid.length == 0) {
                AlertNO('请选择要授权的用户!');
                return;
            }
            if (uid.length > 1) {
                AlertNO('一次只可以操作一个用户!');
                return;
            }
            asyncbox.open({
                id: 'win_give_auth',
                url: '../GiveDepAuth/GiveDepAuth.aspx?id=' + uid,
                modal: true,
                title: '部门授限'
            });
        }
        //仓库授限
        function GiveAuthority_Warehouse() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var uid = cw.aw_GetSelectRows(cw._uid); //返回一维数组
            if (uid.length == 0) {
                AlertNO('请选择要授权的用户!');
                return;
            }
            if (uid.length > 1) {
                AlertNO('一次只可以操作一个用户!');
                return;
            }
            asyncbox.open({
                id: 'win_give_auth',
                url: '../GiveWhAuth/GiveWhAuth.aspx?id=' + uid,
                modal: true,
                title: '仓库授限'
            });
        }
    </script>
</head>
<body onload="search_grid()">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=auth.AuthView("System_Member_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="update()" style='<%=auth.AuthView("System_Member_Edit")%>'>修改</a>
        <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=auth.AuthView("System_Member_Delete")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" onclick="GiveAuthority()" style='<%=auth.AuthView("System_Member_Auth")%>'>授权</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('System_Member')" style='<%=auth.FormatView()%>'>格式</a>
        <a plain="true" id="m_advanced" class="easyui-menubutton" menu="#menu_more_fun">更多功能</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--高级菜单-->
    <div id="menu_more_fun" style="width:150px;">
        <div onclick="GiveAuthority_Warehouse()" style='<%=auth.AuthView("System_Member_WhAuth")%>'>仓库授限</div>
        <div onclick="GiveAuthority_Department()" style='<%=auth.AuthView("System_Member_DepAuth")%>'>部门授限</div>
	</div>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,iconCls:'icon-search'"
        style="width:400px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">用户名:</td>
                <td><input type="text" class="edit_text_box" id="username"/></td>
            </tr>
            <tr>
                <td style="text-align:right">状态:</td>
                <td>
                    <select id="status">
                        <option value=""></option>
                        <option value="1">启用</option>
                        <option value="0">注销</option>
                    </select>
                </td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
</body>
</html>
