﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore.Model;
using SysCore.DAL;
using System.Data;
using SysCore.Control;

public partial class System_Member_Member_Edit : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    public int uid;
    protected void Page_Load(object sender, EventArgs e)
    {
        string action = Request["action"];
        xview.Add("action", action);
        //update为修改状态
        if (action.Equals("Update")) BindData();
        RoleDAL rdal = new RoleDAL();
        MemberDAL mdal = new MemberDAL();
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by id asc";
        ht.Add("order_field", order_field);
        ht.Add("page", 1);
        ht.Add("page_size", 1000);
        DataTable dt = rdal.GetList(ht, "id,role_name");
        string role_html = "";
        foreach (DataRow dr in dt.Rows)
        {
            string check = "";
            if (action.Equals("Update"))
            {
                if (mdal.IsBelongRole(uid, Convert.ToInt32(dr["id"])))
                {
                    check = " checked ";
                }
            }
            role_html += "<input type='checkbox' name='roles' value='" + dr["id"].ToString() + "' " + check + ">" + dr["role_name"].ToString() + "<br/>";
        }
        xview.Add("role_html", role_html);
    }
    /// <summary>
    /// 绑定页面数据
    /// </summary>
    void BindData()
    {
        uid = Convert.ToInt32(Request["uid"]);
        MemberDAL dal = new MemberDAL();
        Member m = dal.Get(uid);
        xview.Add("uid", uid);
        xview.Add("username", m.username);
        xview.Add("nickname", m.nickname);
        xview.Add("password", m.password);
        xview.Add("status", m.status);
        if (new AuthDAL().CheckUserIsAdmin(uid))
        {
            xview.Add("is_admin", "1");
        }
        else
        {
            xview.Add("is_admin", "0");
        }
    }
}