﻿<%@ WebService Language="C#" Class="Login_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Function;
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
//若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消对下行的注释。 
 [System.Web.Script.Services.ScriptService]
public class Login_Service  : System.Web.Services.WebService {

    [WebMethod(EnableSession = true)]
    public string Login(string db_id,string username, string password, string login_date)
    {
        XLogin xl = new XLogin();
        try
        {
            Session.Timeout = 120;
            return xl.Login(db_id, username, password, login_date);
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }

    [WebMethod(EnableSession = true)]
    public string CheckHasLogin(string db_id, string username)
    {
        XLogin xl = new XLogin();
        try
        {
            SqlUtil su = new SqlUtil();
            su.SetDatabaseName("master");
            string db_name = "xplat" + db_id;
            if (!CheckConnection())
                return "数据库连接失败，请到后台配置！";
            string sql = "select count(1) from master..sysdatabases where [name]=@db_name;";
            SqlParameter[] par = {
                new SqlParameter("db_name", db_name)
            };
            object exist = su.ExecuteScalar(sql, par);
            if (Convert.ToInt32(exist) == 0)
            {
                HttpContext.Current.Session["db_id"] = "";
                return "账套" + db_id + "不存在！";
            }
            su.SetDatabaseName(db_name);
            sql = @"select count(1) from System_OnlineUsers ou
                    left join System_Member m on ou.u_id=m.uid
                    where m.username=@username";
            SqlParameter[] par2 = {
                new SqlParameter("@username", username)
            };
            if (Convert.ToInt32(su.ExecuteScalar(sql, par2)) == 0)
            {
                return "0";
            }
            else
            {
                return "1";
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 测试数据库连接
    /// </summary>
    /// <returns></returns>
    bool CheckConnection()
    {

        try
        {
            SqlUtil su = new SqlUtil();
            su.SetDatabaseName("master"); 
            SqlConnection conn = new SqlConnection(su.GetConnectString());
            conn.Open();
            conn.Close();
            return true;
        }
        catch
        {
            return false;
        }
    }
}