﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

public partial class System_GrfPrinter_PrintTemplate_Edit : System.Web.UI.Page
{
    string action;
    int id;
    public Hashtable xview = new Hashtable();
    public string disable_edit = "";
    public string download_link = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        action = Request.QueryString["action"];
        if (!Page.IsPostBack)
        {
            if (action.Equals("Update"))
            {
                BindData();
            }
            else
            {
                btnDesign.Enabled = false;
            }
            module.Text = Request.QueryString["module"];
        }
        
    }
    void BindData()
    {
        id = Convert.ToInt32(Request["prt_id"]);
        PrintTemplateDAL dal = new PrintTemplateDAL();
        PrintTemplate m = dal.Get(id);
        template_name.Text = m.template_name;
        prt_id.Text = m.prt_id.ToString();
        is_system.SelectedValue = m.is_system.ToString();
        sql_where.Text = m.sql_where;
        grf_file_info.Text = m.grf_file;
        if (m.is_system == 1)
        {
            btn_save.Enabled = false;
            btnDesign.Enabled = false;
            system_tip.Text = "系统默认模板不允许修改";
        }
        download_link = "<a href='" + m.grf_file + "'>下载模板</a>";

    }

    protected void btn_save_Click(object sender, EventArgs e)
    {
        PrintTemplateDAL dal = new PrintTemplateDAL();
        PrintTemplate m = new PrintTemplate();
        if (action.Equals("Update"))
        {
            id = Convert.ToInt32(Request["prt_id"]);
            m = dal.Get(id);
        }
        if (module.Text.Trim().Equals(""))
        {
                msg.Text="请输入模块编号!";
                return;
        }
        if (template_name.Text.Trim().Equals(""))
        {
            msg.Text = "请输入模板名称!";
            return;
        }
        if (action.Equals("Add") && grf_file.FileName.Trim().Equals(""))
        {
            msg.Text = "请选择模板文件!";
            return;
        }
        m.module = module.Text;
        m.template_name = template_name.Text.Trim();
        
        m.is_system = Convert.ToInt32(is_system.SelectedValue);
        m.sql_where = sql_where.Text;

        
        string ext;
        string db_id = new LoginInfo().db_id.ToString();
        if (!grf_file.FileName.Equals(""))
        {
            string[] arr = grf_file.FileName.Split('.');
            ext = arr[arr.Length - 1].ToLower();
            if (!ext.Equals("grf"))
            {
                msg.Text = "请上传后缀为.grf的报表模板格式!";
                return;
            }
            string filename = grf_file.FileName.Split('/')[grf_file.FileName.Split('/').Length - 1];

            string save_path_base = "../../Upload/" + db_id;
            if (!Directory.Exists(Server.MapPath(save_path_base)))
            {
                Directory.CreateDirectory(Server.MapPath(save_path_base));
            }
            save_path_base = "../../Upload/" + db_id + "/Grf";
            if (!Directory.Exists(Server.MapPath(save_path_base)))
            {
                Directory.CreateDirectory(Server.MapPath(save_path_base));
            }
            string save_path = save_path_base + "/" + filename;
            string real_save_path = Server.MapPath(save_path);
            grf_file.SaveAs(real_save_path);
            m.grf_file = save_path;
            
        }
        try
        {
            if (action.Equals("Add"))
            {
                dal.Add(m);
            }
            else
            {
                dal.Update(m);
            }
            Response.Redirect(Request.QueryString["from_url"]);
        }
        catch (Exception er)
        {
            msg.Text = er.Message;
        }
    }
    protected void btn_back_Click(object sender, EventArgs e)
    {
        Response.Redirect(Request.QueryString["from_url"]);
    }
    protected void btnDesign_Click(object sender, EventArgs e)
    {
        string url = "../GrfPrinter/PrintTemplate_Design.aspx?prt_id=" + prt_id.Text;
        string caption = "设计模板-" + template_name.Text;
        string script = "top.OpenWindow('Activate', 'Design_Grf', '" + caption + "', '" + url + "')";
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>" + script + "</script>"); 
    }
}