﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class System_GiveWhAuth_GiveWhAuth_Tree : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateTree();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateTree()
    {
        int id = Convert.ToInt32(Request["id"]);
        string where = "where isnull(is_stop,0)=0";
        DataTable tb = new WarehouseDAL().GetListAllWhere(where);
        DTree dt = new DTree("dt");
        dt.AddParentNode("0", "-1", "选择仓库");
        WhAuthDAL dal = new WhAuthDAL();
        foreach (DataRow dr in tb.Rows)
        {
            string wh_id = dr["wh_id"].ToString();
            string parent_id = "0";
            string wh_code = dr["wh_code"].ToString(); 
            string wh_name = dr["wh_name"].ToString();
            bool has_auth = dal.CheckMemberHasWhAuth(id, Convert.ToInt32(wh_id));
            string check = "";
            if (has_auth)
            {
                check = " checked=\"checked\"";
            }
            string checkbox = "<input style=\"width:12px;height:12px\" type=\"checkbox\" name=\"tree_check\" value=\"" + wh_id + "\"" + check + ">";
            string title = checkbox + " " + wh_code + " " + wh_name;
            dt.AddChildNode(wh_id, parent_id, title, "javascript:SelectCategory(\\'" + wh_id + "\\')", "", "", "../../Scripts/dtree/images/folder.gif");
        }
        xview.Add("dtree", dt.GetTree());
    }
}
