﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class System_GiveDepAuth_GiveDepAuth_Tree : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateTree();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateTree()
    {
        int id = Convert.ToInt32(Request["id"]);
        string where = "where isnull(is_stop,0)=0";
        DataTable tb = new DepartmentDAL().GetListAll(where);
        DTree dt = new DTree("dt");
        dt.AddParentNode("0", "-1", "选择部门");
        DepAuthDAL dal = new DepAuthDAL();
        foreach (DataRow dr in tb.Rows)
        {
            string dep_id = dr["dep_id"].ToString();
            string parent_id = dr["parent_id"].ToString();
            string dep_code = dr["dep_code"].ToString(); 
            string dep_name = dr["dep_name"].ToString();
            bool has_auth = dal.CheckMemberHasDepAuth(id, Convert.ToInt32(dep_id));
            string check = "";
            if (has_auth)
            {
                check = " checked=\"checked\"";
            }
            string checkbox = "<input style=\"width:12px;height:12px\" type=\"checkbox\" name=\"tree_check\" value=\"" + dep_id + "\"" + check + ">";
            string title = checkbox + " " + dep_code + " " + dep_name;
            dt.AddChildNode(dep_id, parent_id, title, "javascript:SelectCategory(\\'" + dep_id + "\\')", "", "", "../../Scripts/dtree/images/folder.gif");
        }
        xview.Add("dtree", dt.GetTree());
    }
}
